package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 将单元中的日志投递到Kafka的topic中。 */
public class CtltsCreateKafkaDataSendTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateKafkaDataSendTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/dataSend/createKafkaTask", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateKafkaDataSendTaskResponse send(
            Credential credential, CreateKafkaDataSendTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateKafkaDataSendTaskResponse.class);
    }

    public static class CreateKafkaDataSendTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID 可通过获取项目列表接口获取 */
        @JsonProperty("originProjectCode")
        private String originProjectCode;

        /** 日志单元ID 可通过日志单元列表获取 */
        @JsonProperty("originUnitCode")
        private String originUnitCode;

        /** 任务名称，任务名称2-64个字符(字母、数字、下划线和连字符-)，以字母开始 */
        @JsonProperty("taskName")
        private String taskName;

        /**
         * kafka集群实例ID。可参考<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=48&api=7382&data=83&isNormal=1&vid=330">查询kafka实例</a>
         */
        @JsonProperty("instanceId")
        private String instanceId;

        /**
         * kafka集群实例名称。可参考<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=48&api=7382&data=83&isNormal=1&vid=330">查询kafka实例</a>
         */
        @JsonProperty("instanceName")
        private String instanceName;

        /**
         * kafka实例所属vpcid。可参考<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=48&api=7382&data=83&isNormal=1&vid=330">查询kafka实例</a>
         */
        @JsonProperty("vpcId")
        private String vpcId;

        /**
         * afka实例任一子网id。可参考<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=48&api=7382&data=83&isNormal=1&vid=330">查询kafka实例</a>
         */
        @JsonProperty("subnetId")
        private String subnetId;

        /**
         * 投递topic。可参考<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=48&api=7396&data=83&isNormal=1&vid=330">查询kafka主题</a>
         */
        @JsonProperty("topic")
        private String topic;

        /** 投递范围。2：指定时间点结束；3：持续投递。默认为2 */
        @JsonProperty("processRange")
        private String processRange;

        /** 任务开始时间[毫秒]，默认为当前时间 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 任务结束时间[毫秒]，默认为startTime + 30分钟 为RANGE时，该参数仅在processRange为2时生效 */
        @JsonProperty("endTime")
        private Long endTime;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getOriginProjectCode() {
            return this.originProjectCode;
        }

        public void setOriginProjectCode(String originProjectCode) {
            this.originProjectCode = originProjectCode;
        }

        public String getOriginUnitCode() {
            return this.originUnitCode;
        }

        public void setOriginUnitCode(String originUnitCode) {
            this.originUnitCode = originUnitCode;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getVpcId() {
            return this.vpcId;
        }

        public void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public String getSubnetId() {
            return this.subnetId;
        }

        public void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public String getTopic() {
            return this.topic;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public String getProcessRange() {
            return this.processRange;
        }

        public void setProcessRange(String processRange) {
            this.processRange = processRange;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }
    }

    public static class CreateKafkaDataSendTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求返回体 */
        @JsonProperty("returnObj")
        private CreateKafkaDataSendTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public CreateKafkaDataSendTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateKafkaDataSendTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateKafkaDataSendTaskReturnObjResponse {
        /** 任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }
}
