package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 为指定日志单元创建索引。 */
public class CtltsCreateIndexApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateIndexApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/index/createIndex", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateIndexResponse send(Credential credential, CreateIndexRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateIndexResponse.class);
    }

    public static class CreateIndexRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID。可在云日志控制台 日志管理->日志项目列表->鼠标悬浮查看日志项目ID */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID。可在云日志控制台 日志管理 -> 日志项目列表 -> 展开单元列表 -> 鼠标悬浮查看日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 是否开启全文索引，不填写则保留原有配置（默认开启） */
        @JsonProperty("fullTextIndex")
        private Boolean fullTextIndex;

        /** 索引列表 */
        @JsonProperty("fields")
        private List<CreateIndexFieldsRequest> fields;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Boolean getFullTextIndex() {
            return this.fullTextIndex;
        }

        public void setFullTextIndex(Boolean fullTextIndex) {
            this.fullTextIndex = fullTextIndex;
        }

        public List<CreateIndexFieldsRequest> getFields() {
            return this.fields;
        }

        public void setFields(List<CreateIndexFieldsRequest> fields) {
            this.fields = fields;
        }
    }

    public static class CreateIndexFieldsRequest {
        /** 索引名，仅支持数字、字母、下划线、连字符(-)、点(.), 64个字符内且必须以字母开头 */
        @JsonProperty("fieldName")
        private String fieldName;

        /** 字段的数据类型。double：代表浮点型；text：代表字符串 */
        @JsonProperty("dataType")
        private String dataType;

        public String getFieldName() {
            return this.fieldName;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }
    }

    public static class CreateIndexResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private CreateIndexReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public CreateIndexReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateIndexReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateIndexReturnObjResponse {}
}
