package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建主机组 */
public class CtltsCreateHostGroupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateHostGroupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/hostGroup/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateHostGroupResponse send(Credential credential, CreateHostGroupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateHostGroupResponse.class);
    }

    public static class CreateHostGroupRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机组名称。仅支持字母、数字和连字符(-)、下划线，且长度在1-64个字符内 */
        @JsonProperty("hostGroupName")
        private String hostGroupName;

        /** 主机组描述，长度在250字符内 */
        @JsonProperty("description")
        private String description;

        /**
         * 主机标识类型，支持uuid和sign（自定义标识），可参考<a
         * href="https://www.ctyun.cn/document/10261471/10977630">主机组管理</a>
         */
        @JsonProperty("hostIdentityType")
        private String hostIdentityType;

        /**
         * 主机uuid列表。当hostIdentityType=uuid时该参数必填，当hostIdentityType=sign时不用填。可以进入采集器安装目录
         * /app/cams/lmtagent 下，查看app_info.json文件，instance_id字段即为主机uuid。
         */
        @JsonProperty("hostList")
        private List<String> hostList;

        /** 主机组类型。1：云容器引擎；2：云主机。不填默认为云主机 */
        @JsonProperty("type")
        private Byte type;

        /** 自定义标识列表。当hostIdentityType=sign时，该参数必填。最多支持10个。 */
        @JsonProperty("signList")
        private List<String> signList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getHostGroupName() {
            return this.hostGroupName;
        }

        public void setHostGroupName(String hostGroupName) {
            this.hostGroupName = hostGroupName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getHostIdentityType() {
            return this.hostIdentityType;
        }

        public void setHostIdentityType(String hostIdentityType) {
            this.hostIdentityType = hostIdentityType;
        }

        public List<String> getHostList() {
            return this.hostList;
        }

        public void setHostList(List<String> hostList) {
            this.hostList = hostList;
        }

        public Byte getType() {
            return this.type;
        }

        public void setType(Byte type) {
            this.type = type;
        }

        public List<String> getSignList() {
            return this.signList;
        }

        public void setSignList(List<String> signList) {
            this.signList = signList;
        }
    }

    public static class CreateHostGroupResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private String statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 返回结果对象 */
        @JsonProperty("returnObj")
        private CreateHostGroupReturnObjResponse returnObj;

        public String getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public CreateHostGroupReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateHostGroupReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateHostGroupReturnObjResponse {
        /** 主机组编码 */
        @JsonProperty("hostGroupCode")
        private String hostGroupCode;

        public String getHostGroupCode() {
            return this.hostGroupCode;
        }

        public void setHostGroupCode(String hostGroupCode) {
            this.hostGroupCode = hostGroupCode;
        }
    }
}
