package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建产品委托授权 */
public class CtltsCreateDelegateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateDelegateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/delegate/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateDelegateResponse send(Credential credential, CreateDelegateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateDelegateResponse.class);
    }

    public static class CreateDelegateRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 产品委托信息 */
        @JsonProperty("delegates")
        private List<CreateDelegateDelegatesRequest> delegates;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<CreateDelegateDelegatesRequest> getDelegates() {
            return this.delegates;
        }

        public void setDelegates(List<CreateDelegateDelegatesRequest> delegates) {
            this.delegates = delegates;
        }
    }

    public static class CreateDelegateDelegatesRequest {
        /** 产品类型，可选值：vpce；kafka；ebm；ecs；cce；crs */
        @JsonProperty("type")
        private String type;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class CreateDelegateResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private List<CreateDelegateReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<CreateDelegateReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<CreateDelegateReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateDelegateReturnObjResponse {
        /** 委托结果，true：成功；false：失败 */
        @JsonProperty("result")
        private Boolean result;

        /** 委托产品类型 */
        @JsonProperty("type")
        private String type;

        /** 委托名称 */
        @JsonProperty("delegateName")
        private String delegateName;

        public Boolean getResult() {
            return this.result;
        }

        public void setResult(Boolean result) {
            this.result = result;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDelegateName() {
            return this.delegateName;
        }

        public void setDelegateName(String delegateName) {
            this.delegateName = delegateName;
        }
    }
}
