package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建加工任务 */
public class CtltsCreateDataProcessTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateDataProcessTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/dataProcess/createProcessTask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateDataProcessTaskResponse send(
            Credential credential, CreateDataProcessTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateDataProcessTaskResponse.class);
    }

    public static class CreateDataProcessTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志项目ID，可通过获取项目列表接口获取 */
        @JsonProperty("projectCode")
        private String projectCode;

        /** 日志单元ID，可通过日志单元列表获取 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 任务名称：用户自定义，支持最大64个字符 - 必填 */
        @JsonProperty("taskName")
        private String taskName;

        /** 加工时间类型。CONTINUOUS：持续投递；RANGE：指定时间点结束 */
        @JsonProperty("processRange")
        private String processRange;

        /** 目标列表, 目前仅支持加工到一个目标，填多个时，以第一个为准 */
        @JsonProperty("aimList")
        private List<CreateDataProcessTaskAimListRequest> aimList;

        /** 任务开始时间[毫秒]，默认为当前时间 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 任务结束时间[毫秒]，默认为startTime + 30分钟 为RANGE时，该参数才有效 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 加工脚本, 默认不加工 */
        @JsonProperty("processScript")
        private String processScript;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectCode() {
            return this.projectCode;
        }

        public void setProjectCode(String projectCode) {
            this.projectCode = projectCode;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public void setTaskName(String taskName) {
            this.taskName = taskName;
        }

        public String getProcessRange() {
            return this.processRange;
        }

        public void setProcessRange(String processRange) {
            this.processRange = processRange;
        }

        public List<CreateDataProcessTaskAimListRequest> getAimList() {
            return this.aimList;
        }

        public void setAimList(List<CreateDataProcessTaskAimListRequest> aimList) {
            this.aimList = aimList;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public String getProcessScript() {
            return this.processScript;
        }

        public void setProcessScript(String processScript) {
            this.processScript = processScript;
        }
    }

    public static class CreateDataProcessTaskAimListRequest {
        /** 目标名称：用户自定义，支持最大64个字符 */
        @JsonProperty("aimName")
        private String aimName;

        /** 目标日志项目ID：下拉列表选择当前租户的所有日志项目 */
        @JsonProperty("aimProjectCode")
        private String aimProjectCode;

        /** 目标日志单元ID：下拉列表展示所选日志项目下的所有日志单元。若未选日志项目，则日志单元禁用不可点击 */
        @JsonProperty("aimUnitCode")
        private String aimUnitCode;

        public String getAimName() {
            return this.aimName;
        }

        public void setAimName(String aimName) {
            this.aimName = aimName;
        }

        public String getAimProjectCode() {
            return this.aimProjectCode;
        }

        public void setAimProjectCode(String aimProjectCode) {
            this.aimProjectCode = aimProjectCode;
        }

        public String getAimUnitCode() {
            return this.aimUnitCode;
        }

        public void setAimUnitCode(String aimUnitCode) {
            this.aimUnitCode = aimUnitCode;
        }
    }

    public static class CreateDataProcessTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码,仅错误时返回,例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 消息内容 */
        @JsonProperty("message")
        private String message;

        /** 请求接口返回的数据体 */
        @JsonProperty("returnObj")
        private CreateDataProcessTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateDataProcessTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateDataProcessTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateDataProcessTaskReturnObjResponse {
        /** 任务编码 */
        @JsonProperty("taskCode")
        private String taskCode;

        public String getTaskCode() {
            return this.taskCode;
        }

        public void setTaskCode(String taskCode) {
            this.taskCode = taskCode;
        }
    }
}
