package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 创建下载任务 */
public class CtltsCreateDataDownloadTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateDataDownloadTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/dataDownload/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateDataDownloadTaskResponse send(
            Credential credential, CreateDataDownloadTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateDataDownloadTaskResponse.class);
    }

    public static class CreateDataDownloadTaskRequest {
        /** 资源池编码，可参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志单元ID 可通过日志单元列表获取 */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 日志查询开始时间(秒) */
        @JsonProperty("from")
        private Long from;

        /** 日志查询结束时间(秒) */
        @JsonProperty("to")
        private Long to;

        /** 下载文件格式 默认json。json：json格式；csv：csv格式 */
        @JsonProperty("format")
        private String format;

        /** 下载日志数量 最大支持50000条 */
        @JsonProperty("customLogNum")
        private Integer customLogNum;

        /** 检索条件 下载任务仅支持查询语句，不支持SQL分析语句 */
        @JsonProperty("query")
        private String query;

        /** 日志是否按照日志时间倒叙。 false：日志按照时间正序；true：日志按照时间倒叙 */
        @JsonProperty("reverse")
        private Boolean reverse;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public Long getFrom() {
            return this.from;
        }

        public void setFrom(Long from) {
            this.from = from;
        }

        public Long getTo() {
            return this.to;
        }

        public void setTo(Long to) {
            this.to = to;
        }

        public String getFormat() {
            return this.format;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public Integer getCustomLogNum() {
            return this.customLogNum;
        }

        public void setCustomLogNum(Integer customLogNum) {
            this.customLogNum = customLogNum;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Boolean getReverse() {
            return this.reverse;
        }

        public void setReverse(Boolean reverse) {
            this.reverse = reverse;
        }
    }

    public static class CreateDataDownloadTaskResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 任务编码 */
        @JsonProperty("returnObj")
        private CreateDataDownloadTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public CreateDataDownloadTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateDataDownloadTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateDataDownloadTaskReturnObjResponse {}
}
