package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建采集规则 */
public class CtltsCreateCollectRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCreateCollectRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v1/collectorRule/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateCollectRuleResponse send(Credential credential, CreateCollectRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateCollectRuleResponse.class);
    }

    public static class CreateCollectRuleRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 日志单元ID */
        @JsonProperty("unitCode")
        private String unitCode;

        /** 采集规则名称 */
        @JsonProperty("ruleName")
        private String ruleName;

        /** 采集规则别名，允许修改 */
        @JsonProperty("ruleAliasName")
        private String ruleAliasName;

        /**
         * 采集类型
         * 。1：云主机-文本日志；2：云容器引擎-标准输出；3：云容器引擎-文本日志；4：syslog-协议；5：物理机-文本日志；6：windows事件日志；7：对象存储文件；8：Kafka数据导入；9：Systemd
         * Journal日志；10：审计日志；11：k8s节点文件日志
         */
        @JsonProperty("extractMode")
        private Byte extractMode;

        /**
         * 待采集的日志文件路径列表（目前仅限1个路径）。路径中支持使用*和**通配符，其中**通配符仅能出现一次且仅限用于文件名前。说明：当extractMode=2时，该参数不用填。
         */
        @JsonProperty("logPaths")
        private List<String> logPaths;

        /** 切割模式，不同模式对应其他参数不同。1：单行正则；2：分隔符；3：多行正则；4：单行全文；5：json；6：多行全文；7：组合解析；8：nginx模板解析 */
        @JsonProperty("cuttingMode")
        private String cuttingMode;

        /** 采集策略，默认是增量。add：增量采集；all：全量采集； */
        @JsonProperty("collectPolicy")
        private String collectPolicy;

        /** 自定义时间戳提取格式 */
        @JsonProperty("customTimeInfo")
        private CreateCollectRuleCustomTimeInfoRequest customTimeInfo;

        /** 采集规则高级配置项，包括容器运行参数等配置 */
        @JsonProperty("ruleConfig")
        private CreateCollectRuleRuleConfigRequest ruleConfig;

        /**
         * 接入类型。1：ccse；2：msap；3：csm；4：faas；5：msegw；6：ctgcache；7：kafka；8：mq2；9：amqp；10：host；11：mqtt；12：ebm；13：
         * rcc；14：oss_import；15：kafka_data；16：audit_import；17：cce_one；18：cae
         */
        @JsonProperty("accessType")
        private Byte accessType;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getUnitCode() {
            return this.unitCode;
        }

        public void setUnitCode(String unitCode) {
            this.unitCode = unitCode;
        }

        public String getRuleName() {
            return this.ruleName;
        }

        public void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public String getRuleAliasName() {
            return this.ruleAliasName;
        }

        public void setRuleAliasName(String ruleAliasName) {
            this.ruleAliasName = ruleAliasName;
        }

        public Byte getExtractMode() {
            return this.extractMode;
        }

        public void setExtractMode(Byte extractMode) {
            this.extractMode = extractMode;
        }

        public List<String> getLogPaths() {
            return this.logPaths;
        }

        public void setLogPaths(List<String> logPaths) {
            this.logPaths = logPaths;
        }

        public String getCuttingMode() {
            return this.cuttingMode;
        }

        public void setCuttingMode(String cuttingMode) {
            this.cuttingMode = cuttingMode;
        }

        public String getCollectPolicy() {
            return this.collectPolicy;
        }

        public void setCollectPolicy(String collectPolicy) {
            this.collectPolicy = collectPolicy;
        }

        public CreateCollectRuleCustomTimeInfoRequest getCustomTimeInfo() {
            return this.customTimeInfo;
        }

        public void setCustomTimeInfo(CreateCollectRuleCustomTimeInfoRequest customTimeInfo) {
            this.customTimeInfo = customTimeInfo;
        }

        public CreateCollectRuleRuleConfigRequest getRuleConfig() {
            return this.ruleConfig;
        }

        public void setRuleConfig(CreateCollectRuleRuleConfigRequest ruleConfig) {
            this.ruleConfig = ruleConfig;
        }

        public Byte getAccessType() {
            return this.accessType;
        }

        public void setAccessType(Byte accessType) {
            this.accessType = accessType;
        }
    }

    public static class CreateCollectRuleCustomTimeInfoRequest {
        /** 提取字段名 */
        @JsonProperty("key")
        private String key;

        /** 提取时间格式，如yyyy-MM-dd HH:MM:SS */
        @JsonProperty("timeFormat")
        private String timeFormat;

        /** 时间值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getTimeFormat() {
            return this.timeFormat;
        }

        public void setTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CreateCollectRuleRuleConfigRequest {
        /** 当采集路径中带"**"通配符时，该参数用于指定"**"通配符最大解析深度 */
        @JsonProperty("maxPathDepth")
        private Integer maxPathDepth;

        /** 容器相关配置，若非容器则不存在 */
        @JsonProperty("containers")
        private CreateCollectRuleRuleConfigContainersRequest containers;

        /** 文件路径黑名单（排除文件路径符合条件的文件；必须为绝对路径） */
        @JsonProperty("excludeFilePaths")
        private List<String> excludeFilePaths;

        /** 文件黑名单（排除文件名符合条件的文件；必须为文件名，不包含路径) */
        @JsonProperty("excludeFiles")
        private List<String> excludeFiles;

        /** 目录黑名单（排除文件所在目录符合条件的文件；必须为绝对路径) */
        @JsonProperty("excludeDirs")
        private List<String> excludeDirs;

        /** 分隔符，当切割模式为分隔符时必填 */
        @JsonProperty("delimiter")
        private CreateCollectRuleRuleConfigDelimiterRequest delimiter;

        /** 正则切割模式，当切割模式为正则时需要 */
        @JsonProperty("regex")
        private CreateCollectRuleRuleConfigRegexRequest regex;

        /** 动态获取k8sLabel列表。传该参数，日志会获取对应label的值，将label和value添加到日志中，key：k8s label名 val:日志字段名。 */
        @JsonProperty("dynamicK8sLabels")
        private CreateCollectRuleRuleConfigDynamicK8sLabelsRequest dynamicK8sLabels;

        /** 自定义动态环境变量tag */
        @JsonProperty("dynamicK8sEnv")
        private CreateCollectRuleRuleConfigDynamicK8sEnvRequest dynamicK8sEnv;

        /** 内置的预置字段 */
        @JsonProperty("tags")
        private CreateCollectRuleRuleConfigTagsRequest tags;

        /** 自定义元数据配置对象 */
        @JsonProperty("metaConfig")
        private CreateCollectRuleRuleConfigMetaConfigRequest metaConfig;

        /** 文件编码，可选值包括utf8和gbk */
        @JsonProperty("fileEncoding")
        private String fileEncoding;

        /**
         * 日志主题类型
         * 。none：无，如果定义了类型，但是TopicFormat格式错误，会忽略日志主题，使用none；filepath：从日志采集路径里正则匹配提取；custom：自定义，TopicFormat为定义的值。
         */
        @JsonProperty("topicType")
        private String topicType;

        /** 日志主题格式，与topicType相关。当topicType为filepath，需定义为日志路径提取的正则；当topicType为custom，则可自定义字符串 */
        @JsonProperty("topicFormat")
        private String topicFormat;

        /** 日志过滤信息 */
        @JsonProperty("logFilterVo")
        private CreateCollectRuleRuleConfigLogFilterVoRequest logFilterVo;

        /** 需要丢弃的分词key */
        @JsonProperty("dropKeys")
        private List<String> dropKeys;

        /** 回采日志大小, 单位KB；最小值为0，最大值为10485760 */
        @JsonProperty("tailSize")
        private Integer tailSize;

        /** 是否开启标准输出，默认为true */
        @JsonProperty("enableStdout")
        private Boolean enableStdout;

        /** 是否开启标准错误，默认为true */
        @JsonProperty("enableStderr")
        private Boolean enableStderr;

        /** 解析失败是否保留日志原文，提取模式为1（单行正则）、 3（多行正则）、 5（json）时可配置，默认为true。 */
        @JsonProperty("keepSourceWhenParseFail")
        private Boolean keepSourceWhenParseFail;

        /** 解析成功时是否保留源字段，提取模式为1（单行正则）、 3（多行正则）、 5（json）时可配置，默认为true */
        @JsonProperty("keepSourceWhenParseSucceed")
        private Boolean keepSourceWhenParseSucceed;

        /** 自定义插件配置 */
        @JsonProperty("composePlugin")
        private CreateCollectRuleRuleConfigComposePluginRequest composePlugin;

        public Integer getMaxPathDepth() {
            return this.maxPathDepth;
        }

        public void setMaxPathDepth(Integer maxPathDepth) {
            this.maxPathDepth = maxPathDepth;
        }

        public CreateCollectRuleRuleConfigContainersRequest getContainers() {
            return this.containers;
        }

        public void setContainers(CreateCollectRuleRuleConfigContainersRequest containers) {
            this.containers = containers;
        }

        public List<String> getExcludeFilePaths() {
            return this.excludeFilePaths;
        }

        public void setExcludeFilePaths(List<String> excludeFilePaths) {
            this.excludeFilePaths = excludeFilePaths;
        }

        public List<String> getExcludeFiles() {
            return this.excludeFiles;
        }

        public void setExcludeFiles(List<String> excludeFiles) {
            this.excludeFiles = excludeFiles;
        }

        public List<String> getExcludeDirs() {
            return this.excludeDirs;
        }

        public void setExcludeDirs(List<String> excludeDirs) {
            this.excludeDirs = excludeDirs;
        }

        public CreateCollectRuleRuleConfigDelimiterRequest getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(CreateCollectRuleRuleConfigDelimiterRequest delimiter) {
            this.delimiter = delimiter;
        }

        public CreateCollectRuleRuleConfigRegexRequest getRegex() {
            return this.regex;
        }

        public void setRegex(CreateCollectRuleRuleConfigRegexRequest regex) {
            this.regex = regex;
        }

        public CreateCollectRuleRuleConfigDynamicK8sLabelsRequest getDynamicK8sLabels() {
            return this.dynamicK8sLabels;
        }

        public void setDynamicK8sLabels(
                CreateCollectRuleRuleConfigDynamicK8sLabelsRequest dynamicK8sLabels) {
            this.dynamicK8sLabels = dynamicK8sLabels;
        }

        public CreateCollectRuleRuleConfigDynamicK8sEnvRequest getDynamicK8sEnv() {
            return this.dynamicK8sEnv;
        }

        public void setDynamicK8sEnv(
                CreateCollectRuleRuleConfigDynamicK8sEnvRequest dynamicK8sEnv) {
            this.dynamicK8sEnv = dynamicK8sEnv;
        }

        public CreateCollectRuleRuleConfigTagsRequest getTags() {
            return this.tags;
        }

        public void setTags(CreateCollectRuleRuleConfigTagsRequest tags) {
            this.tags = tags;
        }

        public CreateCollectRuleRuleConfigMetaConfigRequest getMetaConfig() {
            return this.metaConfig;
        }

        public void setMetaConfig(CreateCollectRuleRuleConfigMetaConfigRequest metaConfig) {
            this.metaConfig = metaConfig;
        }

        public String getFileEncoding() {
            return this.fileEncoding;
        }

        public void setFileEncoding(String fileEncoding) {
            this.fileEncoding = fileEncoding;
        }

        public String getTopicType() {
            return this.topicType;
        }

        public void setTopicType(String topicType) {
            this.topicType = topicType;
        }

        public String getTopicFormat() {
            return this.topicFormat;
        }

        public void setTopicFormat(String topicFormat) {
            this.topicFormat = topicFormat;
        }

        public CreateCollectRuleRuleConfigLogFilterVoRequest getLogFilterVo() {
            return this.logFilterVo;
        }

        public void setLogFilterVo(CreateCollectRuleRuleConfigLogFilterVoRequest logFilterVo) {
            this.logFilterVo = logFilterVo;
        }

        public List<String> getDropKeys() {
            return this.dropKeys;
        }

        public void setDropKeys(List<String> dropKeys) {
            this.dropKeys = dropKeys;
        }

        public Integer getTailSize() {
            return this.tailSize;
        }

        public void setTailSize(Integer tailSize) {
            this.tailSize = tailSize;
        }

        public Boolean getEnableStdout() {
            return this.enableStdout;
        }

        public void setEnableStdout(Boolean enableStdout) {
            this.enableStdout = enableStdout;
        }

        public Boolean getEnableStderr() {
            return this.enableStderr;
        }

        public void setEnableStderr(Boolean enableStderr) {
            this.enableStderr = enableStderr;
        }

        public Boolean getKeepSourceWhenParseFail() {
            return this.keepSourceWhenParseFail;
        }

        public void setKeepSourceWhenParseFail(Boolean keepSourceWhenParseFail) {
            this.keepSourceWhenParseFail = keepSourceWhenParseFail;
        }

        public Boolean getKeepSourceWhenParseSucceed() {
            return this.keepSourceWhenParseSucceed;
        }

        public void setKeepSourceWhenParseSucceed(Boolean keepSourceWhenParseSucceed) {
            this.keepSourceWhenParseSucceed = keepSourceWhenParseSucceed;
        }

        public CreateCollectRuleRuleConfigComposePluginRequest getComposePlugin() {
            return this.composePlugin;
        }

        public void setComposePlugin(
                CreateCollectRuleRuleConfigComposePluginRequest composePlugin) {
            this.composePlugin = composePlugin;
        }
    }

    public static class CreateCollectRuleRuleConfigContainersRequest {
        /** 环境变量黑名单 */
        @JsonProperty("excludeEnv")
        private CreateCollectRuleRuleConfigContainersExcludeEnvRequest excludeEnv;

        /** Kubernetes Label 黑名单 */
        @JsonProperty("excludeK8sLabel")
        private CreateCollectRuleRuleConfigContainersExcludeK8sLabelRequest excludeK8sLabel;

        /** 环境变量白名单 */
        @JsonProperty("includeEnv")
        private CreateCollectRuleRuleConfigContainersIncludeEnvRequest includeEnv;

        /** k8s Label 白名单 */
        @JsonProperty("includeK8sLabel")
        private CreateCollectRuleRuleConfigContainersIncludeK8sLabelRequest includeK8sLabel;

        /** Kubernetes 容器名称正则匹配 */
        @JsonProperty("k8sContainerRegex")
        private String k8sContainerRegex;

        /** Kubernetes 命名空间正则匹配 */
        @JsonProperty("k8sNamespaceRegex")
        private String k8sNamespaceRegex;

        /** Kubernetes Pod 名称正则匹配 */
        @JsonProperty("k8sPodRegex")
        private String k8sPodRegex;

        public CreateCollectRuleRuleConfigContainersExcludeEnvRequest getExcludeEnv() {
            return this.excludeEnv;
        }

        public void setExcludeEnv(
                CreateCollectRuleRuleConfigContainersExcludeEnvRequest excludeEnv) {
            this.excludeEnv = excludeEnv;
        }

        public CreateCollectRuleRuleConfigContainersExcludeK8sLabelRequest getExcludeK8sLabel() {
            return this.excludeK8sLabel;
        }

        public void setExcludeK8sLabel(
                CreateCollectRuleRuleConfigContainersExcludeK8sLabelRequest excludeK8sLabel) {
            this.excludeK8sLabel = excludeK8sLabel;
        }

        public CreateCollectRuleRuleConfigContainersIncludeEnvRequest getIncludeEnv() {
            return this.includeEnv;
        }

        public void setIncludeEnv(
                CreateCollectRuleRuleConfigContainersIncludeEnvRequest includeEnv) {
            this.includeEnv = includeEnv;
        }

        public CreateCollectRuleRuleConfigContainersIncludeK8sLabelRequest getIncludeK8sLabel() {
            return this.includeK8sLabel;
        }

        public void setIncludeK8sLabel(
                CreateCollectRuleRuleConfigContainersIncludeK8sLabelRequest includeK8sLabel) {
            this.includeK8sLabel = includeK8sLabel;
        }

        public String getK8sContainerRegex() {
            return this.k8sContainerRegex;
        }

        public void setK8sContainerRegex(String k8sContainerRegex) {
            this.k8sContainerRegex = k8sContainerRegex;
        }

        public String getK8sNamespaceRegex() {
            return this.k8sNamespaceRegex;
        }

        public void setK8sNamespaceRegex(String k8sNamespaceRegex) {
            this.k8sNamespaceRegex = k8sNamespaceRegex;
        }

        public String getK8sPodRegex() {
            return this.k8sPodRegex;
        }

        public void setK8sPodRegex(String k8sPodRegex) {
            this.k8sPodRegex = k8sPodRegex;
        }
    }

    public static class CreateCollectRuleRuleConfigDelimiterRequest {
        /** 分隔符 */
        @JsonProperty("delimiter")
        private String delimiter;

        /** 分割所得类型字段，输入顺序会被使用 */
        @JsonProperty("logContent")
        private List<CreateCollectRuleRuleConfigDelimiterLogContentRequest> logContent;

        public String getDelimiter() {
            return this.delimiter;
        }

        public void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public List<CreateCollectRuleRuleConfigDelimiterLogContentRequest> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<CreateCollectRuleRuleConfigDelimiterLogContentRequest> logContent) {
            this.logContent = logContent;
        }
    }

    public static class CreateCollectRuleRuleConfigRegexRequest {
        /** 提取正则表达式，例如：(\d+-\d+-\d+\s\S+)\s+\[([^]]+)]\s+(\w+)\s+(\S+)\s+(.*) */
        @JsonProperty("regexStr")
        private String regexStr;

        /** 分割所得类型字段，输入顺序会被使用，正则/多行正则时会被匹配使用 */
        @JsonProperty("logContent")
        private List<CreateCollectRuleRuleConfigRegexLogContentRequest> logContent;

        public String getRegexStr() {
            return this.regexStr;
        }

        public void setRegexStr(String regexStr) {
            this.regexStr = regexStr;
        }

        public List<CreateCollectRuleRuleConfigRegexLogContentRequest> getLogContent() {
            return this.logContent;
        }

        public void setLogContent(
                List<CreateCollectRuleRuleConfigRegexLogContentRequest> logContent) {
            this.logContent = logContent;
        }
    }

    public static class CreateCollectRuleRuleConfigDynamicK8sLabelsRequest {}

    public static class CreateCollectRuleRuleConfigDynamicK8sEnvRequest {}

    public static class CreateCollectRuleRuleConfigTagsRequest {}

    public static class CreateCollectRuleRuleConfigMetaConfigRequest {
        /**
         * 自定义预置字段key，包括__tag__podIp、__tag__containerName、__tag__hostName、__tag__podName、__tag__hostIp、__tag__appName、__tag__namespace
         */
        @JsonProperty("selfPresetKeys")
        private List<String> selfPresetKeys;

        /** 自定义键值对 */
        @JsonProperty("addFields")
        private CreateCollectRuleRuleConfigMetaConfigAddFieldsRequest addFields;

        public List<String> getSelfPresetKeys() {
            return this.selfPresetKeys;
        }

        public void setSelfPresetKeys(List<String> selfPresetKeys) {
            this.selfPresetKeys = selfPresetKeys;
        }

        public CreateCollectRuleRuleConfigMetaConfigAddFieldsRequest getAddFields() {
            return this.addFields;
        }

        public void setAddFields(CreateCollectRuleRuleConfigMetaConfigAddFieldsRequest addFields) {
            this.addFields = addFields;
        }
    }

    public static class CreateCollectRuleRuleConfigLogFilterVoRequest {
        /** 需要保留kv日志 */
        @JsonProperty("include")
        private CreateCollectRuleRuleConfigLogFilterVoIncludeRequest include;

        /** 需要丢弃的kv日志 */
        @JsonProperty("exclude")
        private CreateCollectRuleRuleConfigLogFilterVoExcludeRequest exclude;

        public CreateCollectRuleRuleConfigLogFilterVoIncludeRequest getInclude() {
            return this.include;
        }

        public void setInclude(CreateCollectRuleRuleConfigLogFilterVoIncludeRequest include) {
            this.include = include;
        }

        public CreateCollectRuleRuleConfigLogFilterVoExcludeRequest getExclude() {
            return this.exclude;
        }

        public void setExclude(CreateCollectRuleRuleConfigLogFilterVoExcludeRequest exclude) {
            this.exclude = exclude;
        }
    }

    public static class CreateCollectRuleRuleConfigComposePluginRequest {
        /** 自定义插件字符串，长度不能超过2000 */
        @JsonProperty("processors")
        private String processors;

        /** 日志样例数据，长度不能超过2000 */
        @JsonProperty("logContent")
        private String logContent;

        public String getProcessors() {
            return this.processors;
        }

        public void setProcessors(String processors) {
            this.processors = processors;
        }

        public String getLogContent() {
            return this.logContent;
        }

        public void setLogContent(String logContent) {
            this.logContent = logContent;
        }
    }

    public static class CreateCollectRuleRuleConfigContainersExcludeEnvRequest {}

    public static class CreateCollectRuleRuleConfigContainersExcludeK8sLabelRequest {}

    public static class CreateCollectRuleRuleConfigContainersIncludeEnvRequest {}

    public static class CreateCollectRuleRuleConfigContainersIncludeK8sLabelRequest {}

    public static class CreateCollectRuleRuleConfigDelimiterLogContentRequest {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class CreateCollectRuleRuleConfigRegexLogContentRequest {
        /** 提取字段 */
        @JsonProperty("key")
        private String key;

        /** 数据类型。text：字符串；double：数字 */
        @JsonProperty("type")
        private String type;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class CreateCollectRuleRuleConfigMetaConfigAddFieldsRequest {}

    public static class CreateCollectRuleRuleConfigLogFilterVoIncludeRequest {}

    public static class CreateCollectRuleRuleConfigLogFilterVoExcludeRequest {}

    public static class CreateCollectRuleResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private CreateCollectRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public CreateCollectRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateCollectRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateCollectRuleReturnObjResponse {
        /** 采集规则编码 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }
    }
}
