package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 获取主机组下应用的采集规则列表 */
public class CtltsCollectRulesUnderHostGroupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCollectRulesUnderHostGroupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v1/hostGroup/collectorRule/list", "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CollectRulesUnderHostGroupResponse send(
            Credential credential, CollectRulesUnderHostGroupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.hostGroupCode != null) {
            ctReq.addParam("hostGroupCode", request.hostGroupCode);
            request.hostGroupCode = null;
        }
        if (request.hostGroupName != null) {
            ctReq.addParam("hostGroupName", request.hostGroupName);
            request.hostGroupName = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CollectRulesUnderHostGroupResponse.class);
    }

    public static class CollectRulesUnderHostGroupRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 主机组编码，创建主机组接口会返回主机组编码，方便后续查找。该参数和hostGroupName二选一必填 */
        @JsonProperty("hostGroupCode")
        private String hostGroupCode;

        /** 主机组名称。可以通过主机组列表查询接口获取主机组名称。该参数和hostGroupCode二选一必填 */
        @JsonProperty("hostGroupName")
        private String hostGroupName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getHostGroupCode() {
            return this.hostGroupCode;
        }

        public void setHostGroupCode(String hostGroupCode) {
            this.hostGroupCode = hostGroupCode;
        }

        public String getHostGroupName() {
            return this.hostGroupName;
        }

        public void setHostGroupName(String hostGroupName) {
            this.hostGroupName = hostGroupName;
        }
    }

    public static class CollectRulesUnderHostGroupResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private String returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }
    }
}
