package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 检查采集配置是否存在 */
public class CtltsCheckCollectRuleConfigExistApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsCheckCollectRuleConfigExistApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v1/collectorRule/checkRuleConfigExist",
                        "text/plain");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CheckCollectRuleConfigExistResponse send(
            Credential credential, CheckCollectRuleConfigExistRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.ruleCode != null) {
            ctReq.addParam("ruleCode", request.ruleCode);
            request.ruleCode = null;
        }
        ctReq.writeString("", template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CheckCollectRuleConfigExistResponse.class);
    }

    public static class CheckCollectRuleConfigExistRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 采集规则ID，可通过采集规则列表接口获取。 */
        @JsonProperty("ruleCode")
        private String ruleCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getRuleCode() {
            return this.ruleCode;
        }

        public void setRuleCode(String ruleCode) {
            this.ruleCode = ruleCode;
        }
    }

    public static class CheckCollectRuleConfigExistResponse {
        /** 响应状态码。0：代表正常； -1：代表严重错误； -2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX LTS_0001 */
        @JsonProperty("error")
        private String error;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private CheckCollectRuleConfigExistReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public CheckCollectRuleConfigExistReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CheckCollectRuleConfigExistReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CheckCollectRuleConfigExistReturnObjResponse {
        /** 采集配置是否存在。true：存在；false：不存在 */
        @JsonProperty("configExist")
        private Boolean configExist;

        public Boolean getConfigExist() {
            return this.configExist;
        }

        public void setConfigExist(Boolean configExist) {
            this.configExist = configExist;
        }
    }
}
