package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 批量删除告警规则 */
public class CtltsBatchDeleteAlertRulesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtltsBatchDeleteAlertRulesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v1/alert/rule/batchDeleteAlertRules",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BatchDeleteAlertRulesResponse send(
            Credential credential, BatchDeleteAlertRulesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BatchDeleteAlertRulesResponse.class);
    }

    public static class BatchDeleteAlertRulesRequest {
        /** 资源池编码，请参考<a href="https://www.ctyun.cn/document/10261471/10750612">资源池列表</a> */
        @JsonProperty("regionId")
        private String regionId;

        /** 告警规则编码列表。创建接口和列表接口会返回日志告警规则编码 */
        @JsonProperty("ruleCodes")
        private List<String> ruleCodes;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getRuleCodes() {
            return this.ruleCodes;
        }

        public void setRuleCodes(List<String> ruleCodes) {
            this.ruleCodes = ruleCodes;
        }
    }

    public static class BatchDeleteAlertRulesResponse {
        /** 响应状态码。0：代表正常；-1：代表严重错误；-2：代表普通错误 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 业务错误码，仅错误时返回，例LTS_XXXX */
        @JsonProperty("error")
        private String error;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 请求响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求响应数据体 */
        @JsonProperty("returnObj")
        private BatchDeleteAlertRulesReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public BatchDeleteAlertRulesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BatchDeleteAlertRulesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class BatchDeleteAlertRulesReturnObjResponse {}
}
