package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口创建节点池升级运维任务。 */
public class CcseUpgradeNodePoolApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpgradeNodePoolApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/nodepool/{nodePoolId}/upgrade",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpgradeNodePoolResponse send(Credential credential, UpgradeNodePoolRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.nodePoolId != null) {
            builder.replaceUrl("nodePoolId", request.nodePoolId);
            request.nodePoolId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpgradeNodePoolResponse.class);
    }

    public static class UpgradeNodePoolRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 节点池ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("nodePoolId")
        private String nodePoolId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695"
         * target="_blank">地域和可用区</a>来了解资源池 获取： <span style="background-color: rgb(73, 204,
         * 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=5851&amp;data=87"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 是否升级操作系统 */
        @JsonProperty("osUpgrade")
        private Boolean osUpgrade;

        /** 目标操作系统名称（最新操作系统名称可参考产品文档”升级节点池“章节） */
        @JsonProperty("upgradeImageName")
        private String upgradeImageName;

        /** 目标操作系统镜像ID，请联系相关技术人员获取对应操作系统名称的ID */
        @JsonProperty("upgradeImageID")
        private String upgradeImageID;

        /** 是否升级kubelet */
        @JsonProperty("kubeletUpgrade")
        private Boolean kubeletUpgrade;

        /** 目标kubelet版本名称（最新kubelet版本可参考产品文档”升级节点池“章节） */
        @JsonProperty("upgradeKubeletVersion")
        private String upgradeKubeletVersion;

        /** 否升级容器运行时 */
        @JsonProperty("runtimeUpgrade")
        private Boolean runtimeUpgrade;

        /** 节点池容器运行时类型，目前支持containerd运行时升级 */
        @JsonProperty("runtimeType")
        private String runtimeType;

        /** 目标运行时版本名称（最新运行时版本可参考产品文档”升级节点池“章节） */
        @JsonProperty("upgradeRuntimeVersion")
        private String upgradeRuntimeVersion;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNodePoolId() {
            return this.nodePoolId;
        }

        public void setNodePoolId(String nodePoolId) {
            this.nodePoolId = nodePoolId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Boolean getOsUpgrade() {
            return this.osUpgrade;
        }

        public void setOsUpgrade(Boolean osUpgrade) {
            this.osUpgrade = osUpgrade;
        }

        public String getUpgradeImageName() {
            return this.upgradeImageName;
        }

        public void setUpgradeImageName(String upgradeImageName) {
            this.upgradeImageName = upgradeImageName;
        }

        public String getUpgradeImageID() {
            return this.upgradeImageID;
        }

        public void setUpgradeImageID(String upgradeImageID) {
            this.upgradeImageID = upgradeImageID;
        }

        public Boolean getKubeletUpgrade() {
            return this.kubeletUpgrade;
        }

        public void setKubeletUpgrade(Boolean kubeletUpgrade) {
            this.kubeletUpgrade = kubeletUpgrade;
        }

        public String getUpgradeKubeletVersion() {
            return this.upgradeKubeletVersion;
        }

        public void setUpgradeKubeletVersion(String upgradeKubeletVersion) {
            this.upgradeKubeletVersion = upgradeKubeletVersion;
        }

        public Boolean getRuntimeUpgrade() {
            return this.runtimeUpgrade;
        }

        public void setRuntimeUpgrade(Boolean runtimeUpgrade) {
            this.runtimeUpgrade = runtimeUpgrade;
        }

        public String getRuntimeType() {
            return this.runtimeType;
        }

        public void setRuntimeType(String runtimeType) {
            this.runtimeType = runtimeType;
        }

        public String getUpgradeRuntimeVersion() {
            return this.upgradeRuntimeVersion;
        }

        public void setUpgradeRuntimeVersion(String upgradeRuntimeVersion) {
            this.upgradeRuntimeVersion = upgradeRuntimeVersion;
        }
    }

    public static class UpgradeNodePoolResponse {
        /** 响应对象 */
        @JsonProperty("returnObj")
        private UpgradeNodePoolReturnObjResponse returnObj;

        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public UpgradeNodePoolReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpgradeNodePoolReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpgradeNodePoolReturnObjResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }
}
