package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口升级集群。 */
public class CcseUpgradeClusterApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpgradeClusterApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/upgrade",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpgradeClusterResponse send(Credential credential, UpgradeClusterRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpgradeClusterResponse.class);
    }

    public static class UpgradeClusterRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 集群可升级版本 */
        @JsonProperty("nextVersion")
        private String nextVersion;

        /** 当前版本 */
        @JsonProperty("version")
        private String version;

        /** worker升级并发数量 */
        @JsonProperty("concurrency")
        private Integer concurrency;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getNextVersion() {
            return this.nextVersion;
        }

        public void setNextVersion(String nextVersion) {
            this.nextVersion = nextVersion;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Integer getConcurrency() {
            return this.concurrency;
        }

        public void setConcurrency(Integer concurrency) {
            this.concurrency = concurrency;
        }
    }

    public static class UpgradeClusterResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpgradeClusterReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpgradeClusterReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpgradeClusterReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpgradeClusterReturnObjResponse {
        /** 任务id */
        @JsonProperty("taskId")
        private Long taskId;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** parentTaskId */
        @JsonProperty("parentTaskId")
        private Long parentTaskId;

        /** 节点名称 */
        @JsonProperty("nodeName")
        private String nodeName;

        /** 节点类型，包括master0, master, node */
        @JsonProperty("nodeType")
        private String nodeType;

        /** masterPlanHash */
        @JsonProperty("masterPlanHash")
        private String masterPlanHash;

        /** workerPlanHash */
        @JsonProperty("workerPlanHash")
        private String workerPlanHash;

        /** 任务状态，start：开始升级，end：完成升级，pause：暂停升级 */
        @JsonProperty("taskStatus")
        private String taskStatus;

        /** 版本 */
        @JsonProperty("version")
        private String version;

        /** 状态码，0：无效 1：有效 2：删除 */
        @JsonProperty("status")
        private Integer status;

        /** 创建者 */
        @JsonProperty("createdBy")
        private Long createdBy;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 更新时间 */
        @JsonProperty("updatedTime")
        private String updatedTime;

        public Long getTaskId() {
            return this.taskId;
        }

        public void setTaskId(Long taskId) {
            this.taskId = taskId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public Long getParentTaskId() {
            return this.parentTaskId;
        }

        public void setParentTaskId(Long parentTaskId) {
            this.parentTaskId = parentTaskId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getMasterPlanHash() {
            return this.masterPlanHash;
        }

        public void setMasterPlanHash(String masterPlanHash) {
            this.masterPlanHash = masterPlanHash;
        }

        public String getWorkerPlanHash() {
            return this.workerPlanHash;
        }

        public void setWorkerPlanHash(String workerPlanHash) {
            this.workerPlanHash = workerPlanHash;
        }

        public String getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getCreatedBy() {
            return this.createdBy;
        }

        public void setCreatedBy(Long createdBy) {
            this.createdBy = createdBy;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getUpdatedTime() {
            return this.updatedTime;
        }

        public void setUpdatedTime(String updatedTime) {
            this.updatedTime = updatedTime;
        }
    }
}
