package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口全量更新子账号集群授权信息。 */
public class CcseUpdateSubUserPermissionsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateSubUserPermissionsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/binding",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateSubUserPermissionsResponse send(
            Credential credential, UpdateSubUserPermissionsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateSubUserPermissionsResponse.class);
    }

    public static class UpdateSubUserPermissionsRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 用户ID，可在云容器引擎控制台 > 安全管理 > 授权页面查看子账号列表及对应的用户ID */
        @JsonProperty("userIds")
        private List<Long> userIds;

        /** 权限设置列表 */
        @JsonProperty("data")
        private List<UpdateSubUserPermissionsDataRequest> data;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<Long> getUserIds() {
            return this.userIds;
        }

        public void setUserIds(List<Long> userIds) {
            this.userIds = userIds;
        }

        public List<UpdateSubUserPermissionsDataRequest> getData() {
            return this.data;
        }

        public void setData(List<UpdateSubUserPermissionsDataRequest> data) {
            this.data = data;
        }
    }

    public static class UpdateSubUserPermissionsDataRequest {
        /** 命名空间，不填默认全部命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /**
         * 需要绑定的clusterRole，创建，更新需要填写；删除不需要填 目前支持的检查项及含义如下 ccse:preset:admin 管理员 ccse:preset:ops
         * 运维人员 ccse:preset:dev 开发人员 ccse:preset:view 受限用户
         */
        @JsonProperty("clusterRole")
        private String clusterRole;

        /**
         * clusterRoleBinding或者roleBinding的名称，用于表示权限绑定，创建不需要填写，删除或更新必填；删除或更新通过查询子账号集群授权信息获取： <span
         * style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18049&data=128&isNormal=1&vid=121">查询子账号集群授权信息</a>
         */
        @JsonProperty("bindingName")
        private String bindingName;

        /**
         * rolebinding类型，创建不需要填写，删除或更新必填；删除或更新通过查询子账号集群授权信息获取： <span style="background-color:
         * rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18049&data=128&isNormal=1&vid=121">查询子账号集群授权信息</a>
         */
        @JsonProperty("bindingKind")
        private String bindingKind;

        /** 操作类型。0-增加，1-删除，2-更新。不填默认为0 */
        @JsonProperty("operType")
        private Integer operType;

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getClusterRole() {
            return this.clusterRole;
        }

        public void setClusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
        }

        public String getBindingName() {
            return this.bindingName;
        }

        public void setBindingName(String bindingName) {
            this.bindingName = bindingName;
        }

        public String getBindingKind() {
            return this.bindingKind;
        }

        public void setBindingKind(String bindingKind) {
            this.bindingKind = bindingKind;
        }

        public Integer getOperType() {
            return this.operType;
        }

        public void setOperType(Integer operType) {
            this.operType = operType;
        }
    }

    public static class UpdateSubUserPermissionsResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateSubUserPermissionsReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateSubUserPermissionsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateSubUserPermissionsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpdateSubUserPermissionsReturnObjResponse {}
}
