package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

/** 调用该接口更新节点池。 */
public class CcseUpdateNodePoolApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateNodePoolApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/v2/cce/clusters/{clusterId}/nodepool/{nodePoolId}/update",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateNodePoolResponse send(Credential credential, UpdateNodePoolRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.nodePoolId != null) {
            builder.replaceUrl("nodePoolId", request.nodePoolId);
            request.nodePoolId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateNodePoolResponse.class);
    }

    public static class UpdateNodePoolRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 节点池ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("nodePoolId")
        private String nodePoolId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 节点池名称 */
        @JsonProperty("nodePoolName")
        private String nodePoolName;

        /** 是否自动弹性伸缩 */
        @JsonProperty("enableAutoScale")
        private Boolean enableAutoScale;

        /** 伸缩组最大数量0-20 */
        @JsonProperty("maxNum")
        private Integer maxNum;

        /** 伸缩组最小数量0-20 */
        @JsonProperty("minNum")
        private Integer minNum;

        /** 订单类型 1-包年包月 2-按需计费 */
        @JsonProperty("billMode")
        private String billMode;

        /** 订购时长，billMode为1必传，cycleType为MONTH时，cycleCount为1表示订购1个月 */
        @JsonProperty("cycleCount")
        private Integer cycleCount;

        /** 订购周期类型 MONTH-月 YEAR-年，billMode为1必传 */
        @JsonProperty("cycleType")
        private String cycleType;

        /** 是否自动续订 0-否 1-是，默认为0 */
        @JsonProperty("autoRenewStatus")
        private Integer autoRenewStatus;

        /** 系统盘大小，单位是G 系统盘取值范围： 1、裸金属：取值范围[100,2040] 2、云主机：取值范围[镜像磁盘大小,2040] */
        @JsonProperty("sysDiskSize")
        private Integer sysDiskSize;

        /**
         * 系统盘规格，云硬盘类型，取值范围： SATA：普通IO， SAS：高IO， SSD：超高IO 您可以查看<a
         * href="https://www.ctyun.cn/document/10027696/10162918"
         * target="_blank">磁盘类型及性能介绍</a>磁盘类型相关信息
         */
        @JsonProperty("sysDiskType")
        private String sysDiskType;

        /** 数据盘 */
        @JsonProperty("dataDisks")
        private List<UpdateNodePoolDataDisksRequest> dataDisks;

        /**
         * 子网ID，您可以查看<a href="https://www.ctyun.cn/document/10026755/10098380"
         * target="_blank">基本概念</a>来查找子网的相关定义 获取： <span style="background-color: rgb(73, 204,
         * 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&amp;api=8659&amp;data=94"
         * target="_blank">查询子网列表</a> 注：在多可用区类型资源池下，subnetID通常以“subnet-”开头，非多可用区类型资源池subnetID为uuid格式
         */
        @JsonProperty("subnetUuid")
        private String subnetUuid;

        /** 部署后执行自定义脚本，base64编码 */
        @JsonProperty("visibilityPostHostScript")
        private String visibilityPostHostScript;

        /** 部署前执行自定义脚本，base64编码 */
        @JsonProperty("visibilityHostScript")
        private String visibilityHostScript;

        /** K8S节点标签 */
        @JsonProperty("labels")
        private Map<String,String> labels;

        /** K8S节点注解 */
        @JsonProperty("annotations")
        private Map<String,String> annotations;

        /**
         * 节点污点，格式为
         * [{\"key\":\"{key}\",\"value\":\"{value}\",\"effect\":\"{effect}\"}]，上述的{key}、{value}、{effect}替换为所需字段。effect枚举包括NoSchedule、PreferNoSchedule、NoExecute
         */
        @JsonProperty("taints")
        private List<UpdateNodePoolTaintsRequest> taints;

        /** 是否同步节点标签 */
        @JsonProperty("syncNodeLabels")
        private Boolean syncNodeLabels;

        /** 是否同步节点注解 */
        @JsonProperty("syncNodeAnnotations")
        private Boolean syncNodeAnnotations;

        /** 是否同步节点污点 */
        @JsonProperty("syncNodeTaints")
        private Boolean syncNodeTaints;

        /** 节点是否不可调度 */
        @JsonProperty("nodeUnschedulable")
        private Boolean nodeUnschedulable;

        /** 是否同步集群标签。默认是false。如果为true，则同步以当前集群标签为基准的快照。 */
        @JsonProperty("isSyncClusterResourceLabels")
        private Boolean isSyncClusterResourceLabels;

        /** 云主机资源标签 */
        @JsonProperty("resourceLabels")
        private Map<String,String> resourceLabels;

        /** 托管版集群是否开启节点自愈。0：不开启，1：开启。默认值是0 */
        @JsonProperty("autoRepair")
        private Integer autoRepair;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNodePoolId() {
            return this.nodePoolId;
        }

        public void setNodePoolId(String nodePoolId) {
            this.nodePoolId = nodePoolId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getNodePoolName() {
            return this.nodePoolName;
        }

        public void setNodePoolName(String nodePoolName) {
            this.nodePoolName = nodePoolName;
        }

        public Boolean getEnableAutoScale() {
            return this.enableAutoScale;
        }

        public void setEnableAutoScale(Boolean enableAutoScale) {
            this.enableAutoScale = enableAutoScale;
        }

        public Integer getMaxNum() {
            return this.maxNum;
        }

        public void setMaxNum(Integer maxNum) {
            this.maxNum = maxNum;
        }

        public Integer getMinNum() {
            return this.minNum;
        }

        public void setMinNum(Integer minNum) {
            this.minNum = minNum;
        }

        public String getBillMode() {
            return this.billMode;
        }

        public void setBillMode(String billMode) {
            this.billMode = billMode;
        }

        public Integer getCycleCount() {
            return this.cycleCount;
        }

        public void setCycleCount(Integer cycleCount) {
            this.cycleCount = cycleCount;
        }

        public String getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(String cycleType) {
            this.cycleType = cycleType;
        }

        public Integer getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(Integer autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }

        public Integer getSysDiskSize() {
            return this.sysDiskSize;
        }

        public void setSysDiskSize(Integer sysDiskSize) {
            this.sysDiskSize = sysDiskSize;
        }

        public String getSysDiskType() {
            return this.sysDiskType;
        }

        public void setSysDiskType(String sysDiskType) {
            this.sysDiskType = sysDiskType;
        }

        public List<UpdateNodePoolDataDisksRequest> getDataDisks() {
            return this.dataDisks;
        }

        public void setDataDisks(List<UpdateNodePoolDataDisksRequest> dataDisks) {
            this.dataDisks = dataDisks;
        }

        public String getSubnetUuid() {
            return this.subnetUuid;
        }

        public void setSubnetUuid(String subnetUuid) {
            this.subnetUuid = subnetUuid;
        }

        public String getVisibilityPostHostScript() {
            return this.visibilityPostHostScript;
        }

        public void setVisibilityPostHostScript(String visibilityPostHostScript) {
            this.visibilityPostHostScript = visibilityPostHostScript;
        }

        public String getVisibilityHostScript() {
            return this.visibilityHostScript;
        }

        public void setVisibilityHostScript(String visibilityHostScript) {
            this.visibilityHostScript = visibilityHostScript;
        }

        public Map<String,String> getLabels() {
            return this.labels;
        }

        public void setLabels(Map<String,String> labels) {
            this.labels = labels;
        }

        public Map<String,String> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Map<String,String> annotations) {
            this.annotations = annotations;
        }

        public List<UpdateNodePoolTaintsRequest> getTaints() {
            return this.taints;
        }

        public void setTaints(List<UpdateNodePoolTaintsRequest> taints) {
            this.taints = taints;
        }

        public Boolean getSyncNodeLabels() {
            return this.syncNodeLabels;
        }

        public void setSyncNodeLabels(Boolean syncNodeLabels) {
            this.syncNodeLabels = syncNodeLabels;
        }

        public Boolean getSyncNodeAnnotations() {
            return this.syncNodeAnnotations;
        }

        public void setSyncNodeAnnotations(Boolean syncNodeAnnotations) {
            this.syncNodeAnnotations = syncNodeAnnotations;
        }

        public Boolean getSyncNodeTaints() {
            return this.syncNodeTaints;
        }

        public void setSyncNodeTaints(Boolean syncNodeTaints) {
            this.syncNodeTaints = syncNodeTaints;
        }

        public Boolean getNodeUnschedulable() {
            return this.nodeUnschedulable;
        }

        public void setNodeUnschedulable(Boolean nodeUnschedulable) {
            this.nodeUnschedulable = nodeUnschedulable;
        }

        public Boolean getIsSyncClusterResourceLabels() {
            return this.isSyncClusterResourceLabels;
        }

        public void setIsSyncClusterResourceLabels(Boolean isSyncClusterResourceLabels) {
            this.isSyncClusterResourceLabels = isSyncClusterResourceLabels;
        }

        public Map<String,String> getResourceLabels() {
            return this.resourceLabels;
        }

        public void setResourceLabels(Map<String,String> resourceLabels) {
            this.resourceLabels = resourceLabels;
        }

        public Integer getAutoRepair() {
            return this.autoRepair;
        }

        public void setAutoRepair(Integer autoRepair) {
            this.autoRepair = autoRepair;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class UpdateNodePoolDataDisksRequest {
        /** 数据盘大小，单位为G，取值范围[10,20000] */
        @JsonProperty("size")
        private Integer size;

        /**
         * 数据盘规格名称，取值范围： SATA：普通IO， SAS：高IO， SSD：超高IO 您可以查看<a
         * href="https://www.ctyun.cn/document/10027696/10162918"
         * target="_blank">磁盘类型及性能介绍</a>磁盘类型相关信息
         */
        @JsonProperty("diskSpecName")
        private String diskSpecName;

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public String getDiskSpecName() {
            return this.diskSpecName;
        }

        public void setDiskSpecName(String diskSpecName) {
            this.diskSpecName = diskSpecName;
        }
    }

    public static class UpdateNodePoolLabelsRequest {}

    public static class UpdateNodePoolAnnotationsRequest {}

    public static class UpdateNodePoolTaintsRequest {
        /** 键 */
        @JsonProperty("key")
        private String key;

        /** 值 */
        @JsonProperty("value")
        private String value;

        /** 策略 */
        @JsonProperty("effect")
        private String effect;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }
    }

    public static class UpdateNodePoolResourceLabelsRequest {}

    public static class UpdateNodePoolResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private Boolean returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Boolean returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
