package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口修改控制面组件参数 */
public class CcseUpdateControlPlaneArgsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateControlPlaneArgsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "PUT",
                        "/v2/cce/clusters/{clusterId}/controlplane/arguments",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateControlPlaneArgsResponse send(
            Credential credential, UpdateControlPlaneArgsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateControlPlaneArgsResponse.class);
    }

    public static class UpdateControlPlaneArgsRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** apis启动参数 */
        @JsonProperty("kubeApiServer")
        private UpdateControlPlaneArgsKubeApiServerRequest kubeApiServer;

        /** kcm启动参数 */
        @JsonProperty("kubeControllerManager")
        private UpdateControlPlaneArgsKubeControllerManagerRequest kubeControllerManager;

        /** scheduler启动参数 */
        @JsonProperty("kubeScheduler")
        private UpdateControlPlaneArgsKubeSchedulerRequest kubeScheduler;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public UpdateControlPlaneArgsKubeApiServerRequest getKubeApiServer() {
            return this.kubeApiServer;
        }

        public void setKubeApiServer(UpdateControlPlaneArgsKubeApiServerRequest kubeApiServer) {
            this.kubeApiServer = kubeApiServer;
        }

        public UpdateControlPlaneArgsKubeControllerManagerRequest getKubeControllerManager() {
            return this.kubeControllerManager;
        }

        public void setKubeControllerManager(
                UpdateControlPlaneArgsKubeControllerManagerRequest kubeControllerManager) {
            this.kubeControllerManager = kubeControllerManager;
        }

        public UpdateControlPlaneArgsKubeSchedulerRequest getKubeScheduler() {
            return this.kubeScheduler;
        }

        public void setKubeScheduler(UpdateControlPlaneArgsKubeSchedulerRequest kubeScheduler) {
            this.kubeScheduler = kubeScheduler;
        }
    }

    public static class UpdateControlPlaneArgsKubeApiServerRequest {
        /** 指示处理程序在超时之前必须保持打开请求的持续时间，仅支持单位秒(s) */
        @JsonProperty("requestTimeout")
        private String requestTimeout;

        /** 修改类API请求最大并发数 */
        @JsonProperty("maxMutatingRequestsInflight")
        private String maxMutatingRequestsInflight;

        /** 非修改类API请求最大并发数 */
        @JsonProperty("maxRequestsInflight")
        private String maxRequestsInflight;

        /** 对污点 NotReady:NoExecute 的容忍时长 */
        @JsonProperty("defaultNotReadyTolerationSeconds")
        private String defaultNotReadyTolerationSeconds;

        /** 对污点 Unreachable:NoExecute 的容忍时长 */
        @JsonProperty("defaultUnreachableTolerationSeconds")
        private String defaultUnreachableTolerationSeconds;

        /** 节点限制插件 */
        @JsonProperty("enableAdmissionPluginsNodeRestriction")
        private Boolean enableAdmissionPluginsNodeRestriction;

        /** 节点选择器插件 */
        @JsonProperty("enableAdmissionPluginsPodNodeSelector")
        private Boolean enableAdmissionPluginsPodNodeSelector;

        /** 容忍度限制插件 */
        @JsonProperty("enableAdmissionPluginsPodTolerationRestriction")
        private Boolean enableAdmissionPluginsPodTolerationRestriction;

        /** API 的标识符 */
        @JsonProperty("apiAudiences")
        private String apiAudiences;

        /** 服务帐号令牌颁发者的标识符 */
        @JsonProperty("serviceAccountIssuer")
        private String serviceAccountIssuer;

        public String getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(String requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public String getMaxMutatingRequestsInflight() {
            return this.maxMutatingRequestsInflight;
        }

        public void setMaxMutatingRequestsInflight(String maxMutatingRequestsInflight) {
            this.maxMutatingRequestsInflight = maxMutatingRequestsInflight;
        }

        public String getMaxRequestsInflight() {
            return this.maxRequestsInflight;
        }

        public void setMaxRequestsInflight(String maxRequestsInflight) {
            this.maxRequestsInflight = maxRequestsInflight;
        }

        public String getDefaultNotReadyTolerationSeconds() {
            return this.defaultNotReadyTolerationSeconds;
        }

        public void setDefaultNotReadyTolerationSeconds(String defaultNotReadyTolerationSeconds) {
            this.defaultNotReadyTolerationSeconds = defaultNotReadyTolerationSeconds;
        }

        public String getDefaultUnreachableTolerationSeconds() {
            return this.defaultUnreachableTolerationSeconds;
        }

        public void setDefaultUnreachableTolerationSeconds(
                String defaultUnreachableTolerationSeconds) {
            this.defaultUnreachableTolerationSeconds = defaultUnreachableTolerationSeconds;
        }

        public Boolean getEnableAdmissionPluginsNodeRestriction() {
            return this.enableAdmissionPluginsNodeRestriction;
        }

        public void setEnableAdmissionPluginsNodeRestriction(
                Boolean enableAdmissionPluginsNodeRestriction) {
            this.enableAdmissionPluginsNodeRestriction = enableAdmissionPluginsNodeRestriction;
        }

        public Boolean getEnableAdmissionPluginsPodNodeSelector() {
            return this.enableAdmissionPluginsPodNodeSelector;
        }

        public void setEnableAdmissionPluginsPodNodeSelector(
                Boolean enableAdmissionPluginsPodNodeSelector) {
            this.enableAdmissionPluginsPodNodeSelector = enableAdmissionPluginsPodNodeSelector;
        }

        public Boolean getEnableAdmissionPluginsPodTolerationRestriction() {
            return this.enableAdmissionPluginsPodTolerationRestriction;
        }

        public void setEnableAdmissionPluginsPodTolerationRestriction(
                Boolean enableAdmissionPluginsPodTolerationRestriction) {
            this.enableAdmissionPluginsPodTolerationRestriction =
                    enableAdmissionPluginsPodTolerationRestriction;
        }

        public String getApiAudiences() {
            return this.apiAudiences;
        }

        public void setApiAudiences(String apiAudiences) {
            this.apiAudiences = apiAudiences;
        }

        public String getServiceAccountIssuer() {
            return this.serviceAccountIssuer;
        }

        public void setServiceAccountIssuer(String serviceAccountIssuer) {
            this.serviceAccountIssuer = serviceAccountIssuer;
        }
    }

    public static class UpdateControlPlaneArgsKubeControllerManagerRequest {
        /** 与 API 服务器通信时每秒请求数（QPS）限制 */
        @JsonProperty("kubeApiQps")
        private String kubeApiQps;

        /** 与 Kubernetes API 服务器通信时突发峰值请求个数上限 */
        @JsonProperty("kubeApiBurst")
        private String kubeApiBurst;

        /** 并发同步的 Deployment 对象个数 */
        @JsonProperty("concurrentDeploymentSyncs")
        private String concurrentDeploymentSyncs;

        /** 并发执行的 Endpoints 同步操作个数 */
        @JsonProperty("concurrentEndpointSyncs")
        private String concurrentEndpointSyncs;

        /** 并发同步的垃圾收集工作线程个数 */
        @JsonProperty("concurrentGcSyncs")
        private String concurrentGcSyncs;

        /** 并发同步的 Job 对象个数；Kubernetes 1.28版本引入，若集群版本低于1.28，设值会被忽略 */
        @JsonProperty("concurrentJobSyncs")
        private String concurrentJobSyncs;

        /** 并发同步的 CronJob 对象个数；Kubernetes 1.28版本引入，若集群版本低于1.28，设值会被忽略 */
        @JsonProperty("concurrentCronJobSyncs")
        private String concurrentCronJobSyncs;

        /** 并发同步的 Namespace 对象个数 */
        @JsonProperty("concurrentNamespaceSyncs")
        private String concurrentNamespaceSyncs;

        /** 并发同步的 ReplicaSet 个数 */
        @JsonProperty("concurrentReplicasetSyncs")
        private String concurrentReplicasetSyncs;

        /** 并发同步的 ResourceQuota 对象个数 */
        @JsonProperty("concurrentResourceQuotaSyncs")
        private String concurrentResourceQuotaSyncs;

        /** 并发同步的 Service 对象个数 */
        @JsonProperty("concurrentServiceSyncs")
        private String concurrentServiceSyncs;

        /** 并发同步的服务账号令牌对象个数 */
        @JsonProperty("concurrentServiceaccountTokenSyncs")
        private String concurrentServiceaccountTokenSyncs;

        /** 并发同步的 ttl-after-finished-controller 线程个数 */
        @JsonProperty("concurrentTtlAfterFinishedSyncs")
        private String concurrentTtlAfterFinishedSyncs;

        /** 并发执行的、对水平 Pod 自动扩缩器对象进行同步的数量；Kubernetes 1.26版本引入，若集群版本低于1.26，设值会被忽略 */
        @JsonProperty("concurrentHorizontalPodAutoscalerSyncs")
        private String concurrentHorizontalPodAutoscalerSyncs;

        /** 仅当给定区域中处于非就绪状态的节点（最少 3 个）的占比高于此值时， 才将该区域视为不健康 */
        @JsonProperty("unhealthyZoneThreshold")
        private String unhealthyZoneThreshold;

        /** 区域不健康造成节点失效时，每秒钟从此标志所给的节点上删除 Pod 的节点个数 */
        @JsonProperty("secondaryNodeEvictionRate")
        private String secondaryNodeEvictionRate;

        /** 判断所在集群是否为大规模集群 */
        @JsonProperty("largeClusterSizeThreshold")
        private String largeClusterSizeThreshold;

        /** 节点故障的情况下每秒删除 Pods 的节点数 */
        @JsonProperty("nodeEvictionRate")
        private String nodeEvictionRate;

        /** 水平 Pod 扩缩器对 Pod 数目执行同步操作的周期，仅支持单位秒(s) */
        @JsonProperty("horizontalPodAutoscalerSyncPeriod")
        private String horizontalPodAutoscalerSyncPeriod;

        /** 对伸缩策略相关指标反映的灵敏程度 */
        @JsonProperty("horizontalPodAutoscalerTolerance")
        private String horizontalPodAutoscalerTolerance;

        /** Pod 启动之后可以忽略 CPU 采样值的时长，仅支持单位秒(s) */
        @JsonProperty("horizontalPodAutoscalerCpuInitializationPeriod")
        private String horizontalPodAutoscalerCpuInitializationPeriod;

        /** 自动扩缩程序的回溯时长，仅支持单位秒(s) */
        @JsonProperty("horizontalPodAutoscalerInitialReadinessDelay")
        private String horizontalPodAutoscalerInitialReadinessDelay;

        /** 在已终止 Pod 垃圾收集器删除已终止 Pod 之前，可以保留的已终止 Pod 的个数上限 */
        @JsonProperty("terminatedPodGcThreshold")
        private String terminatedPodGcThreshold;

        /** 启用的控制器 */
        @JsonProperty("controllersResourceQuota")
        private Boolean controllersResourceQuota;

        public String getKubeApiQps() {
            return this.kubeApiQps;
        }

        public void setKubeApiQps(String kubeApiQps) {
            this.kubeApiQps = kubeApiQps;
        }

        public String getKubeApiBurst() {
            return this.kubeApiBurst;
        }

        public void setKubeApiBurst(String kubeApiBurst) {
            this.kubeApiBurst = kubeApiBurst;
        }

        public String getConcurrentDeploymentSyncs() {
            return this.concurrentDeploymentSyncs;
        }

        public void setConcurrentDeploymentSyncs(String concurrentDeploymentSyncs) {
            this.concurrentDeploymentSyncs = concurrentDeploymentSyncs;
        }

        public String getConcurrentEndpointSyncs() {
            return this.concurrentEndpointSyncs;
        }

        public void setConcurrentEndpointSyncs(String concurrentEndpointSyncs) {
            this.concurrentEndpointSyncs = concurrentEndpointSyncs;
        }

        public String getConcurrentGcSyncs() {
            return this.concurrentGcSyncs;
        }

        public void setConcurrentGcSyncs(String concurrentGcSyncs) {
            this.concurrentGcSyncs = concurrentGcSyncs;
        }

        public String getConcurrentJobSyncs() {
            return this.concurrentJobSyncs;
        }

        public void setConcurrentJobSyncs(String concurrentJobSyncs) {
            this.concurrentJobSyncs = concurrentJobSyncs;
        }

        public String getConcurrentCronJobSyncs() {
            return this.concurrentCronJobSyncs;
        }

        public void setConcurrentCronJobSyncs(String concurrentCronJobSyncs) {
            this.concurrentCronJobSyncs = concurrentCronJobSyncs;
        }

        public String getConcurrentNamespaceSyncs() {
            return this.concurrentNamespaceSyncs;
        }

        public void setConcurrentNamespaceSyncs(String concurrentNamespaceSyncs) {
            this.concurrentNamespaceSyncs = concurrentNamespaceSyncs;
        }

        public String getConcurrentReplicasetSyncs() {
            return this.concurrentReplicasetSyncs;
        }

        public void setConcurrentReplicasetSyncs(String concurrentReplicasetSyncs) {
            this.concurrentReplicasetSyncs = concurrentReplicasetSyncs;
        }

        public String getConcurrentResourceQuotaSyncs() {
            return this.concurrentResourceQuotaSyncs;
        }

        public void setConcurrentResourceQuotaSyncs(String concurrentResourceQuotaSyncs) {
            this.concurrentResourceQuotaSyncs = concurrentResourceQuotaSyncs;
        }

        public String getConcurrentServiceSyncs() {
            return this.concurrentServiceSyncs;
        }

        public void setConcurrentServiceSyncs(String concurrentServiceSyncs) {
            this.concurrentServiceSyncs = concurrentServiceSyncs;
        }

        public String getConcurrentServiceaccountTokenSyncs() {
            return this.concurrentServiceaccountTokenSyncs;
        }

        public void setConcurrentServiceaccountTokenSyncs(
                String concurrentServiceaccountTokenSyncs) {
            this.concurrentServiceaccountTokenSyncs = concurrentServiceaccountTokenSyncs;
        }

        public String getConcurrentTtlAfterFinishedSyncs() {
            return this.concurrentTtlAfterFinishedSyncs;
        }

        public void setConcurrentTtlAfterFinishedSyncs(String concurrentTtlAfterFinishedSyncs) {
            this.concurrentTtlAfterFinishedSyncs = concurrentTtlAfterFinishedSyncs;
        }

        public String getConcurrentHorizontalPodAutoscalerSyncs() {
            return this.concurrentHorizontalPodAutoscalerSyncs;
        }

        public void setConcurrentHorizontalPodAutoscalerSyncs(
                String concurrentHorizontalPodAutoscalerSyncs) {
            this.concurrentHorizontalPodAutoscalerSyncs = concurrentHorizontalPodAutoscalerSyncs;
        }

        public String getUnhealthyZoneThreshold() {
            return this.unhealthyZoneThreshold;
        }

        public void setUnhealthyZoneThreshold(String unhealthyZoneThreshold) {
            this.unhealthyZoneThreshold = unhealthyZoneThreshold;
        }

        public String getSecondaryNodeEvictionRate() {
            return this.secondaryNodeEvictionRate;
        }

        public void setSecondaryNodeEvictionRate(String secondaryNodeEvictionRate) {
            this.secondaryNodeEvictionRate = secondaryNodeEvictionRate;
        }

        public String getLargeClusterSizeThreshold() {
            return this.largeClusterSizeThreshold;
        }

        public void setLargeClusterSizeThreshold(String largeClusterSizeThreshold) {
            this.largeClusterSizeThreshold = largeClusterSizeThreshold;
        }

        public String getNodeEvictionRate() {
            return this.nodeEvictionRate;
        }

        public void setNodeEvictionRate(String nodeEvictionRate) {
            this.nodeEvictionRate = nodeEvictionRate;
        }

        public String getHorizontalPodAutoscalerSyncPeriod() {
            return this.horizontalPodAutoscalerSyncPeriod;
        }

        public void setHorizontalPodAutoscalerSyncPeriod(String horizontalPodAutoscalerSyncPeriod) {
            this.horizontalPodAutoscalerSyncPeriod = horizontalPodAutoscalerSyncPeriod;
        }

        public String getHorizontalPodAutoscalerTolerance() {
            return this.horizontalPodAutoscalerTolerance;
        }

        public void setHorizontalPodAutoscalerTolerance(String horizontalPodAutoscalerTolerance) {
            this.horizontalPodAutoscalerTolerance = horizontalPodAutoscalerTolerance;
        }

        public String getHorizontalPodAutoscalerCpuInitializationPeriod() {
            return this.horizontalPodAutoscalerCpuInitializationPeriod;
        }

        public void setHorizontalPodAutoscalerCpuInitializationPeriod(
                String horizontalPodAutoscalerCpuInitializationPeriod) {
            this.horizontalPodAutoscalerCpuInitializationPeriod =
                    horizontalPodAutoscalerCpuInitializationPeriod;
        }

        public String getHorizontalPodAutoscalerInitialReadinessDelay() {
            return this.horizontalPodAutoscalerInitialReadinessDelay;
        }

        public void setHorizontalPodAutoscalerInitialReadinessDelay(
                String horizontalPodAutoscalerInitialReadinessDelay) {
            this.horizontalPodAutoscalerInitialReadinessDelay =
                    horizontalPodAutoscalerInitialReadinessDelay;
        }

        public String getTerminatedPodGcThreshold() {
            return this.terminatedPodGcThreshold;
        }

        public void setTerminatedPodGcThreshold(String terminatedPodGcThreshold) {
            this.terminatedPodGcThreshold = terminatedPodGcThreshold;
        }

        public Boolean getControllersResourceQuota() {
            return this.controllersResourceQuota;
        }

        public void setControllersResourceQuota(Boolean controllersResourceQuota) {
            this.controllersResourceQuota = controllersResourceQuota;
        }
    }

    public static class UpdateControlPlaneArgsKubeSchedulerRequest {
        /** 与 API 服务器通信时每秒请求数（QPS）限制 */
        @JsonProperty("kubeApiQps")
        private String kubeApiQps;

        /** 与 Kubernetes API 服务器通信时突发峰值请求个数上限 */
        @JsonProperty("kubeApiBurst")
        private String kubeApiBurst;

        public String getKubeApiQps() {
            return this.kubeApiQps;
        }

        public void setKubeApiQps(String kubeApiQps) {
            this.kubeApiQps = kubeApiQps;
        }

        public String getKubeApiBurst() {
            return this.kubeApiBurst;
        }

        public void setKubeApiBurst(String kubeApiBurst) {
            this.kubeApiBurst = kubeApiBurst;
        }
    }

    public static class UpdateControlPlaneArgsResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 响应对象 */
        @JsonProperty("returnObj")
        private Boolean returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Boolean returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
