package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口修改主账号下指定子账号的集群KubeConfig过期时间，需要使用主账号ak调用 */
public class CcseUpdateClusterKubeConfigExpirationTimeApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseUpdateClusterKubeConfigExpirationTimeApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/certificate/kubeconfig/expire",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateClusterKubeConfigExpirationTimeResponse send(
            Credential credential, UpdateClusterKubeConfigExpirationTimeRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateClusterKubeConfigExpirationTimeResponse.class);
    }

    public static class UpdateClusterKubeConfigExpirationTimeRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 用户ID，可在云容器引擎控制台 > 安全管理 > 授权页面查看主账号名下的子账号列表及对应的用户ID */
        @JsonProperty("userId")
        private Long userId;

        /** 证书过期秒数，最长为一年（31536000） */
        @JsonProperty("validPeriod")
        private Integer validPeriod;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }

        public Integer getValidPeriod() {
            return this.validPeriod;
        }

        public void setValidPeriod(Integer validPeriod) {
            this.validPeriod = validPeriod;
        }
    }

    public static class UpdateClusterKubeConfigExpirationTimeResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 响应对象 */
        @JsonProperty("returnObj")
        private UpdateClusterKubeConfigExpirationTimeReturnObjResponse returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public UpdateClusterKubeConfigExpirationTimeReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateClusterKubeConfigExpirationTimeReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class UpdateClusterKubeConfigExpirationTimeReturnObjResponse {}
}
