package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 续订集群 */
public class CcseRenewClusterApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseRenewClusterApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v2/cce/clusters/renew", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RenewClusterResponse send(Credential credential, RenewClusterRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RenewClusterResponse.class);
    }

    public static class RenewClusterRequest {
        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("resPoolId")
        private String resPoolId;

        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 订购周期类型，3（按月）、5（按年） */
        @JsonProperty("cycleType")
        private String cycleType;

        /** 订购时长 */
        @JsonProperty("cycleCnt")
        private Integer cycleCnt;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getResPoolId() {
            return this.resPoolId;
        }

        public void setResPoolId(String resPoolId) {
            this.resPoolId = resPoolId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(String cycleType) {
            this.cycleType = cycleType;
        }

        public Integer getCycleCnt() {
            return this.cycleCnt;
        }

        public void setCycleCnt(Integer cycleCnt) {
            this.cycleCnt = cycleCnt;
        }
    }

    public static class RenewClusterResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 响应对象 */
        @JsonProperty("returnObj")
        private RenewClusterReturnObjResponse returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public RenewClusterReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(RenewClusterReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class RenewClusterReturnObjResponse {
        /** 20240925163106798886 */
        @JsonProperty("orderNo")
        private String orderNo;

        /** 8a0109f9196d41db9d92893fe4522c75 */
        @JsonProperty("orderId")
        private String orderId;

        public String getOrderNo() {
            return this.orderNo;
        }

        public void setOrderNo(String orderNo) {
            this.orderNo = orderNo;
        }

        public String getOrderId() {
            return this.orderId;
        }

        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }
    }
}
