package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 在指定集群下移除节点 */
public class CcseRemoveNodeV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseRemoveNodeV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/nodepool/{nodePoolId}/nodes/remove",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RemoveNodeV2Response send(Credential credential, RemoveNodeV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.nodePoolId != null) {
            builder.replaceUrl("nodePoolId", request.nodePoolId);
            request.nodePoolId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RemoveNodeV2Response.class);
    }

    public static class RemoveNodeV2Request {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 节点池ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("nodePoolId")
        private String nodePoolId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 移除节点的名称，可通过<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=43&api=18020&data=128&isNormal=1&vid=121"
         * target="_blank">查询节点池详情</a>接口返回的节点池节点信息查询节点名称
         */
        @JsonProperty("nodes")
        private List<String> nodes;

        /** 云主机密码登录类型：目前只支持 password */
        @JsonProperty("loginType")
        private String loginType;

        /**
         * 云主机或物理机，用户登录密码，如果loginType=password，这该项为必填项，满足以下规则： 物理机：用户密码，满足以下规则：长度在8～30个字符；
         * 必须包含大小写字母和（至少一个数字或者特殊字符）； 特殊符号可选：()`~!@#$%&*_-+=\ 云主机：长度在8～30个字符；
         * 必须包含大写字母、小写字母、数字以及特殊符号中的三项； 特殊符号可选：()`-!@#$%^&*_-+=｜{}[]:;'<>,.?/且不能以斜线号 / 开头；
         * 不能包含3个及以上连续字符； 移除节点时password字段可选择加密，具体加密方法请参见<a
         * href="https://www.ctyun.cn/document/10083472/11002096"
         * target="_blank">password字段加密的方法</a>
         */
        @JsonProperty("password")
        private String password;

        /** 是否强制移除，默认是true */
        @JsonProperty("forcedRemoved")
        private Boolean forcedRemoved;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNodePoolId() {
            return this.nodePoolId;
        }

        public void setNodePoolId(String nodePoolId) {
            this.nodePoolId = nodePoolId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<String> nodes) {
            this.nodes = nodes;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Boolean getForcedRemoved() {
            return this.forcedRemoved;
        }

        public void setForcedRemoved(Boolean forcedRemoved) {
            this.forcedRemoved = forcedRemoved;
        }
    }

    public static class RemoveNodeV2Response {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 响应对象 */
        @JsonProperty("returnObj")
        private Boolean returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Boolean returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
