package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询任务详情 */
public class CcseListClusterTasksApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseListClusterTasksApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/tasks/{clusterId}/alltasks",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListClusterTasksResponse send(Credential credential, ListClusterTasksRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListClusterTasksResponse.class);
    }

    public static class ListClusterTasksRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 每页显示数量 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 分页查询页数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListClusterTasksResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求结果 */
        @JsonProperty("returnObj")
        private ListClusterTasksReturnObjResponse returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListClusterTasksReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListClusterTasksReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListClusterTasksReturnObjResponse {
        /** 诊断任务记录 */
        @JsonProperty("records")
        private List<ListClusterTasksReturnObjRecordsResponse> records;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 当前页数 */
        @JsonProperty("current")
        private Integer current;

        /** 每页大小 */
        @JsonProperty("size")
        private Integer size;

        public List<ListClusterTasksReturnObjRecordsResponse> getRecords() {
            return this.records;
        }

        public void setRecords(List<ListClusterTasksReturnObjRecordsResponse> records) {
            this.records = records;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getCurrent() {
            return this.current;
        }

        public void setCurrent(Integer current) {
            this.current = current;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }
    }

    public static class ListClusterTasksReturnObjRecordsResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 资源池Id */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务类型 */
        @JsonProperty("taskType")
        private String taskType;

        /** 任务状态 */
        @JsonProperty("taskStatus")
        private String taskStatus;

        /** 并行数 */
        @JsonProperty("parallelNumber")
        private Integer parallelNumber;

        /** 任务内容 */
        @JsonProperty("taskContent")
        private String taskContent;

        /** 任务执行结果 */
        @JsonProperty("taskResult")
        private String taskResult;

        /** 重试次数 */
        @JsonProperty("retryTime")
        private Integer retryTime;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 修改时间 */
        @JsonProperty("modifyTime")
        private String modifyTime;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskType() {
            return this.taskType;
        }

        public void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public String getTaskStatus() {
            return this.taskStatus;
        }

        public void setTaskStatus(String taskStatus) {
            this.taskStatus = taskStatus;
        }

        public Integer getParallelNumber() {
            return this.parallelNumber;
        }

        public void setParallelNumber(Integer parallelNumber) {
            this.parallelNumber = parallelNumber;
        }

        public String getTaskContent() {
            return this.taskContent;
        }

        public void setTaskContent(String taskContent) {
            this.taskContent = taskContent;
        }

        public String getTaskResult() {
            return this.taskResult;
        }

        public void setTaskResult(String taskResult) {
            this.taskResult = taskResult;
        }

        public Integer getRetryTime() {
            return this.retryTime;
        }

        public void setRetryTime(Integer retryTime) {
            this.retryTime = retryTime;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getModifyTime() {
            return this.modifyTime;
        }

        public void setModifyTime(String modifyTime) {
            this.modifyTime = modifyTime;
        }
    }
}
