package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查看模板实例详情。 */
public class CcseGetTemplateInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetTemplateInstanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/namespaces/{namespaceName}/templateinstance/{templateInstanceName}/detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetTemplateInstanceResponse send(
            Credential credential, GetTemplateInstanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.namespaceName != null) {
            builder.replaceUrl("namespaceName", request.namespaceName);
            request.namespaceName = null;
        }
        if (request.templateInstanceName != null) {
            builder.replaceUrl("templateInstanceName", request.templateInstanceName);
            request.templateInstanceName = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetTemplateInstanceResponse.class);
    }

    public static class GetTemplateInstanceRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 命名空间名称 */
        @JsonProperty("namespaceName")
        private String namespaceName;

        /** 模板名称 */
        @JsonProperty("templateInstanceName")
        private String templateInstanceName;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNamespaceName() {
            return this.namespaceName;
        }

        public void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public String getTemplateInstanceName() {
            return this.templateInstanceName;
        }

        public void setTemplateInstanceName(String templateInstanceName) {
            this.templateInstanceName = templateInstanceName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetTemplateInstanceResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetTemplateInstanceReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetTemplateInstanceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetTemplateInstanceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetTemplateInstanceReturnObjResponse {
        /** 发布版本列表 */
        @JsonProperty("releaseHistoryListDTOS")
        private List<GetTemplateInstanceReturnObjReleaseHistoryListDTOSResponse>
                releaseHistoryListDTOS;

        /** 首次发布时间 */
        @JsonProperty("firstDeployTime")
        private String firstDeployTime;

        /** 最新发布时间 */
        @JsonProperty("lastDeployTime")
        private String lastDeployTime;

        /** 实例名称 */
        @JsonProperty("name")
        private String name;

        /** 命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /** values参数 */
        @JsonProperty("values")
        private String values;

        /** 资源列表 */
        @JsonProperty("resourceDTOS")
        private List<GetTemplateInstanceReturnObjResourceDTOSResponse> resourceDTOS;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** Chart版本 */
        @JsonProperty("chartVersion")
        private String chartVersion;

        /** 状态 */
        @JsonProperty("status")
        private String status;

        /** 历史事件 */
        @JsonProperty("lastEvent")
        private String lastEvent;

        /** readme */
        @JsonProperty("readme")
        private String readme;

        /** externalIps */
        @JsonProperty("externalIps")
        private List<String> externalIps;

        /** Chart地址 */
        @JsonProperty("chartUrl")
        private String chartUrl;

        /** kubeConfig路径 */
        @JsonProperty("kubeConfigPath")
        private String kubeConfigPath;

        /** 镜像实例仓库id */
        @JsonProperty("repositoryId")
        private String repositoryId;

        /** chart名称 */
        @JsonProperty("chartName")
        private String chartName;

        /** icon */
        @JsonProperty("icon")
        private String icon;

        public List<GetTemplateInstanceReturnObjReleaseHistoryListDTOSResponse>
                getReleaseHistoryListDTOS() {
            return this.releaseHistoryListDTOS;
        }

        public void setReleaseHistoryListDTOS(
                List<GetTemplateInstanceReturnObjReleaseHistoryListDTOSResponse>
                        releaseHistoryListDTOS) {
            this.releaseHistoryListDTOS = releaseHistoryListDTOS;
        }

        public String getFirstDeployTime() {
            return this.firstDeployTime;
        }

        public void setFirstDeployTime(String firstDeployTime) {
            this.firstDeployTime = firstDeployTime;
        }

        public String getLastDeployTime() {
            return this.lastDeployTime;
        }

        public void setLastDeployTime(String lastDeployTime) {
            this.lastDeployTime = lastDeployTime;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        public List<GetTemplateInstanceReturnObjResourceDTOSResponse> getResourceDTOS() {
            return this.resourceDTOS;
        }

        public void setResourceDTOS(
                List<GetTemplateInstanceReturnObjResourceDTOSResponse> resourceDTOS) {
            this.resourceDTOS = resourceDTOS;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getChartVersion() {
            return this.chartVersion;
        }

        public void setChartVersion(String chartVersion) {
            this.chartVersion = chartVersion;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getLastEvent() {
            return this.lastEvent;
        }

        public void setLastEvent(String lastEvent) {
            this.lastEvent = lastEvent;
        }

        public String getReadme() {
            return this.readme;
        }

        public void setReadme(String readme) {
            this.readme = readme;
        }

        public List<String> getExternalIps() {
            return this.externalIps;
        }

        public void setExternalIps(List<String> externalIps) {
            this.externalIps = externalIps;
        }

        public String getChartUrl() {
            return this.chartUrl;
        }

        public void setChartUrl(String chartUrl) {
            this.chartUrl = chartUrl;
        }

        public String getKubeConfigPath() {
            return this.kubeConfigPath;
        }

        public void setKubeConfigPath(String kubeConfigPath) {
            this.kubeConfigPath = kubeConfigPath;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public String getChartName() {
            return this.chartName;
        }

        public void setChartName(String chartName) {
            this.chartName = chartName;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }
    }

    public static class GetTemplateInstanceReturnObjReleaseHistoryListDTOSResponse {
        /** 版本 */
        @JsonProperty("revision")
        private String revision;

        /** 更新时间 */
        @JsonProperty("updated")
        private String updated;

        /** 状态 */
        @JsonProperty("status")
        private String status;

        /** chart名称和版本 */
        @JsonProperty("chart")
        private String chart;

        /** app版本 */
        @JsonProperty("appVersion")
        private String appVersion;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 集群id */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 实例名称 */
        @JsonProperty("name")
        private String name;

        /** 命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /** chart版本 */
        @JsonProperty("chartVersion")
        private String chartVersion;

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        public String getUpdated() {
            return this.updated;
        }

        public void setUpdated(String updated) {
            this.updated = updated;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getChart() {
            return this.chart;
        }

        public void setChart(String chart) {
            this.chart = chart;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getChartVersion() {
            return this.chartVersion;
        }

        public void setChartVersion(String chartVersion) {
            this.chartVersion = chartVersion;
        }
    }

    public static class GetTemplateInstanceReturnObjResourceDTOSResponse {
        /** 名称 */
        @JsonProperty("name")
        private String name;

        /** 命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /** 资源类型 */
        @JsonProperty("kind")
        private String kind;

        /** YAML内容 */
        @JsonProperty("yaml")
        private String yaml;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getKind() {
            return this.kind;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public String getYaml() {
            return this.yaml;
        }

        public void setYaml(String yaml) {
            this.yaml = yaml;
        }
    }
}
