package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查询子账号集群授权信息。 */
public class CcseGetSubUserPermissionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetSubUserPermissionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/binding",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetSubUserPermissionResponse send(
            Credential credential, GetSubUserPermissionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.userId != null) {
            ctReq.addParam("userId", String.valueOf(request.userId));
            request.userId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetSubUserPermissionResponse.class);
    }

    public static class GetSubUserPermissionRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 用户ID，可在云容器引擎控制台 > 安全管理 > 授权页面查看子账号列表及对应的用户ID */
        @JsonProperty("userId")
        private Long userId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }
    }

    public static class GetSubUserPermissionResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetSubUserPermissionReturnObjResponse> returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetSubUserPermissionReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetSubUserPermissionReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetSubUserPermissionReturnObjResponse {
        /** 绑定标识 */
        @JsonProperty("bindingName")
        private String bindingName;

        /** 角色绑定类型 */
        @JsonProperty("bindingKind")
        private String bindingKind;

        /** 角色绑定命名空间，为空表示全部命名空间 */
        @JsonProperty("namespace")
        private String namespace;

        /** 绑定的角色名 */
        @JsonProperty("clusterRole")
        private String clusterRole;

        public String getBindingName() {
            return this.bindingName;
        }

        public void setBindingName(String bindingName) {
            this.bindingName = bindingName;
        }

        public String getBindingKind() {
            return this.bindingKind;
        }

        public void setBindingKind(String bindingKind) {
            this.bindingKind = bindingKind;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getClusterRole() {
            return this.clusterRole;
        }

        public void setClusterRole(String clusterRole) {
            this.clusterRole = clusterRole;
        }
    }
}
