package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口可查询插件实例的详细信息。 */
public class CcseGetPluginInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetPluginInstanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/plugininstance/{instanceName}/detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetPluginInstanceResponse send(Credential credential, GetPluginInstanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.instanceName != null) {
            builder.replaceUrl("instanceName", request.instanceName);
            request.instanceName = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetPluginInstanceResponse.class);
    }

    public static class GetPluginInstanceRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 插件名称 */
        @JsonProperty("instanceName")
        private String instanceName;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetPluginInstanceResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private GetPluginInstanceReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetPluginInstanceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetPluginInstanceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetPluginInstanceReturnObjResponse {
        /** 插件实例发布历史版本列表 */
        @JsonProperty("releaseHistoryListDTOS")
        private List<GetPluginInstanceReturnObjReleaseHistoryListDTOSResponse>
                releaseHistoryListDTOS;

        /** 首次发布时间。 */
        @JsonProperty("firstDeployTime")
        private String firstDeployTime;

        /** 最新发布时间。 */
        @JsonProperty("lastDeployTime")
        private String lastDeployTime;

        /** 插件实例名称。 */
        @JsonProperty("name")
        private String name;

        /** 命名空间。 */
        @JsonProperty("namespace")
        private String namespace;

        /** values参数。 */
        @JsonProperty("values")
        private String values;

        /** 资源列表。 */
        @JsonProperty("resourceDTOS")
        private List<GetPluginInstanceReturnObjResourceDTOSResponse> resourceDTOS;

        /** 集群ID */
        @JsonProperty("clusterName")
        private String clusterName;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** chart版本 */
        @JsonProperty("chartVersion")
        private String chartVersion;

        /** 状态 */
        @JsonProperty("status")
        private String status;

        /** 说明 */
        @JsonProperty("readme")
        private String readme;

        /** chart url */
        @JsonProperty("chartUrl")
        private String chartUrl;

        /** 仓库ID */
        @JsonProperty("repositoryId")
        private String repositoryId;

        /** chart名称 */
        @JsonProperty("chartName")
        private String chartName;

        /** icon名称 */
        @JsonProperty("icon")
        private String icon;

        public List<GetPluginInstanceReturnObjReleaseHistoryListDTOSResponse>
                getReleaseHistoryListDTOS() {
            return this.releaseHistoryListDTOS;
        }

        public void setReleaseHistoryListDTOS(
                List<GetPluginInstanceReturnObjReleaseHistoryListDTOSResponse>
                        releaseHistoryListDTOS) {
            this.releaseHistoryListDTOS = releaseHistoryListDTOS;
        }

        public String getFirstDeployTime() {
            return this.firstDeployTime;
        }

        public void setFirstDeployTime(String firstDeployTime) {
            this.firstDeployTime = firstDeployTime;
        }

        public String getLastDeployTime() {
            return this.lastDeployTime;
        }

        public void setLastDeployTime(String lastDeployTime) {
            this.lastDeployTime = lastDeployTime;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getValues() {
            return this.values;
        }

        public void setValues(String values) {
            this.values = values;
        }

        public List<GetPluginInstanceReturnObjResourceDTOSResponse> getResourceDTOS() {
            return this.resourceDTOS;
        }

        public void setResourceDTOS(
                List<GetPluginInstanceReturnObjResourceDTOSResponse> resourceDTOS) {
            this.resourceDTOS = resourceDTOS;
        }

        public String getClusterName() {
            return this.clusterName;
        }

        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getChartVersion() {
            return this.chartVersion;
        }

        public void setChartVersion(String chartVersion) {
            this.chartVersion = chartVersion;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getReadme() {
            return this.readme;
        }

        public void setReadme(String readme) {
            this.readme = readme;
        }

        public String getChartUrl() {
            return this.chartUrl;
        }

        public void setChartUrl(String chartUrl) {
            this.chartUrl = chartUrl;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public String getChartName() {
            return this.chartName;
        }

        public void setChartName(String chartName) {
            this.chartName = chartName;
        }

        public String getIcon() {
            return this.icon;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }
    }

    public static class GetPluginInstanceReturnObjReleaseHistoryListDTOSResponse {
        /** 版本 */
        @JsonProperty("revision")
        private String revision;

        /** 更新时间。 */
        @JsonProperty("updated")
        private String updated;

        /** 状态。 */
        @JsonProperty("status")
        private String status;

        /** Chart名称和版本。 */
        @JsonProperty("chart")
        private String chart;

        /** 版本。 */
        @JsonProperty("appVersion")
        private String appVersion;

        /** 描述。 */
        @JsonProperty("description")
        private String description;

        /** 集群ID。 */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 实例名称。 */
        @JsonProperty("name")
        private String name;

        /** 命名空间。 */
        @JsonProperty("namespace")
        private String namespace;

        /** Chart名称。 */
        @JsonProperty("chartName")
        private String chartName;

        /** Chart版本。 */
        @JsonProperty("chartVersion")
        private String chartVersion;

        public String getRevision() {
            return this.revision;
        }

        public void setRevision(String revision) {
            this.revision = revision;
        }

        public String getUpdated() {
            return this.updated;
        }

        public void setUpdated(String updated) {
            this.updated = updated;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getChart() {
            return this.chart;
        }

        public void setChart(String chart) {
            this.chart = chart;
        }

        public String getAppVersion() {
            return this.appVersion;
        }

        public void setAppVersion(String appVersion) {
            this.appVersion = appVersion;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getChartName() {
            return this.chartName;
        }

        public void setChartName(String chartName) {
            this.chartName = chartName;
        }

        public String getChartVersion() {
            return this.chartVersion;
        }

        public void setChartVersion(String chartVersion) {
            this.chartVersion = chartVersion;
        }
    }

    public static class GetPluginInstanceReturnObjResourceDTOSResponse {
        /** 资源名称。 */
        @JsonProperty("name")
        private String name;

        /** 资源命名空间。 */
        @JsonProperty("namespace")
        private String namespace;

        /** 资源kind。 */
        @JsonProperty("kind")
        private String kind;

        /** 资源内容。 */
        @JsonProperty("yaml")
        private String yaml;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getKind() {
            return this.kind;
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public String getYaml() {
            return this.yaml;
        }

        public void setYaml(String yaml) {
            this.yaml = yaml;
        }
    }
}
