package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询节点详情 */
public class CcseGetNodeDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetNodeDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/nodes/{nodeName}",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetNodeDetailResponse send(Credential credential, GetNodeDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.nodeName != null) {
            builder.replaceUrl("nodeName", request.nodeName);
            request.nodeName = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetNodeDetailResponse.class);
    }

    public static class GetNodeDetailRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 节点名称 */
        @JsonProperty("nodeName")
        private String nodeName;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10026730/10028695">地域和可用区</a>来了解资源池 获取：
         * <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=5851&amp;data=87">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetNodeDetailResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private GetNodeDetailReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetNodeDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetNodeDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetNodeDetailReturnObjResponse {
        /** 集群节点名称 */
        @JsonProperty("nodeName")
        private String nodeName;

        /**
         * 节点类型，取值：<br>
         * 1：master <br>
         * 2：slave
         */
        @JsonProperty("nodeType")
        private Integer nodeType;

        /**
         * 节点状态，取值：<br>
         * normal：健康<br>
         * abnormal：异常<br>
         * expulsion：驱逐中
         */
        @JsonProperty("nodeStatus")
        private String nodeStatus;

        /**
         * 是否调度，取值： 1：是 <br>
         * 0：否
         */
        @JsonProperty("isSchedule")
        private Integer isSchedule;

        /**
         * 是否驱逐，取值： 1：是 <br>
         * 0：否
         */
        @JsonProperty("isEvict")
        private Integer isEvict;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        /** 主机管理ip */
        @JsonProperty("hostIp")
        private String hostIp;

        /** 主机业务ipv6 */
        @JsonProperty("hostExtraIpv6")
        private String hostExtraIpv6;

        /** Kubelet 版本 */
        @JsonProperty("kubeletVersion")
        private String kubeletVersion;

        /** Pod CIDR */
        @JsonProperty("podCidr")
        private String podCidr;

        /** 内核版本 */
        @JsonProperty("kernelVersion")
        private String kernelVersion;

        /** OS 镜像 */
        @JsonProperty("osImageVersion")
        private String osImageVersion;

        /** KubeProxy 版本 */
        @JsonProperty("kubeProxyVersion")
        private String kubeProxyVersion;

        /** 云主机ID */
        @JsonProperty("ecsId")
        private String ecsId;

        /** host类型 */
        @JsonProperty("hostType")
        private String hostType;

        /** 可用区名称 */
        @JsonProperty("zoneName")
        private String zoneName;

        /** 可用区编码 */
        @JsonProperty("zoneCode")
        private String zoneCode;

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public Integer getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(Integer nodeType) {
            this.nodeType = nodeType;
        }

        public String getNodeStatus() {
            return this.nodeStatus;
        }

        public void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        public Integer getIsSchedule() {
            return this.isSchedule;
        }

        public void setIsSchedule(Integer isSchedule) {
            this.isSchedule = isSchedule;
        }

        public Integer getIsEvict() {
            return this.isEvict;
        }

        public void setIsEvict(Integer isEvict) {
            this.isEvict = isEvict;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        public String getHostIp() {
            return this.hostIp;
        }

        public void setHostIp(String hostIp) {
            this.hostIp = hostIp;
        }

        public String getHostExtraIpv6() {
            return this.hostExtraIpv6;
        }

        public void setHostExtraIpv6(String hostExtraIpv6) {
            this.hostExtraIpv6 = hostExtraIpv6;
        }

        public String getKubeletVersion() {
            return this.kubeletVersion;
        }

        public void setKubeletVersion(String kubeletVersion) {
            this.kubeletVersion = kubeletVersion;
        }

        public String getPodCidr() {
            return this.podCidr;
        }

        public void setPodCidr(String podCidr) {
            this.podCidr = podCidr;
        }

        public String getKernelVersion() {
            return this.kernelVersion;
        }

        public void setKernelVersion(String kernelVersion) {
            this.kernelVersion = kernelVersion;
        }

        public String getOsImageVersion() {
            return this.osImageVersion;
        }

        public void setOsImageVersion(String osImageVersion) {
            this.osImageVersion = osImageVersion;
        }

        public String getKubeProxyVersion() {
            return this.kubeProxyVersion;
        }

        public void setKubeProxyVersion(String kubeProxyVersion) {
            this.kubeProxyVersion = kubeProxyVersion;
        }

        public String getEcsId() {
            return this.ecsId;
        }

        public void setEcsId(String ecsId) {
            this.ecsId = ecsId;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getZoneName() {
            return this.zoneName;
        }

        public void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public String getZoneCode() {
            return this.zoneCode;
        }

        public void setZoneCode(String zoneCode) {
            this.zoneCode = zoneCode;
        }
    }
}
