package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口查询支持Kubernetes版本。 */
public class CcseGetKubernetesVersionsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetKubernetesVersionsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/cce/metadata/versions", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetKubernetesVersionsResponse send(
            Credential credential, GetKubernetesVersionsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetKubernetesVersionsResponse.class);
    }

    public static class GetKubernetesVersionsRequest {
        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetKubernetesVersionsResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private List<GetKubernetesVersionsReturnObjResponse> returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<GetKubernetesVersionsReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<GetKubernetesVersionsReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetKubernetesVersionsReturnObjResponse {
        /** 容器运行时 */
        @JsonProperty("runtimes")
        private List<GetKubernetesVersionsReturnObjRuntimesResponse> runtimes;

        /** 是否支持多AZ */
        @JsonProperty("multi_az")
        private String multi_az;

        /** 版本 */
        @JsonProperty("version")
        private String version;

        public List<GetKubernetesVersionsReturnObjRuntimesResponse> getRuntimes() {
            return this.runtimes;
        }

        public void setRuntimes(List<GetKubernetesVersionsReturnObjRuntimesResponse> runtimes) {
            this.runtimes = runtimes;
        }

        public String getMulti_az() {
            return this.multi_az;
        }

        public void setMulti_az(String multi_az) {
            this.multi_az = multi_az;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    public static class GetKubernetesVersionsReturnObjRuntimesResponse {
        /** 容器运行时名称，包括docker、containerd */
        @JsonProperty("name")
        private String name;

        /** 容器运行时版本 */
        @JsonProperty("version")
        private String version;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }
}
