package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询指定集群事件列表 */
public class CcseGetClusterEventsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetClusterEventsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/cce/events/{clusterId}", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClusterEventsResponse send(Credential credential, GetClusterEventsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.eventType != null) {
            ctReq.addParam("eventType", request.eventType);
            request.eventType = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClusterEventsResponse.class);
    }

    public static class GetClusterEventsRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 事件类型 */
        @JsonProperty("eventType")
        private String eventType;

        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        /** 每页显示数量 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 分页查询页数 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getEventType() {
            return this.eventType;
        }

        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class GetClusterEventsResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 请求结果 */
        @JsonProperty("returnObj")
        private GetClusterEventsReturnObjResponse returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClusterEventsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClusterEventsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClusterEventsReturnObjResponse {
        /** 诊断任务记录 */
        @JsonProperty("records")
        private List<GetClusterEventsReturnObjRecordsResponse> records;

        /** 总记录数 */
        @JsonProperty("total")
        private Integer total;

        /** 总页数 */
        @JsonProperty("pages")
        private Integer pages;

        /** 当前页数 */
        @JsonProperty("current")
        private Integer current;

        /** 每页大小 */
        @JsonProperty("size")
        private Integer size;

        public List<GetClusterEventsReturnObjRecordsResponse> getRecords() {
            return this.records;
        }

        public void setRecords(List<GetClusterEventsReturnObjRecordsResponse> records) {
            this.records = records;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getCurrent() {
            return this.current;
        }

        public void setCurrent(Integer current) {
            this.current = current;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }
    }

    public static class GetClusterEventsReturnObjRecordsResponse {
        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        /** 集群ID */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 事件Id */
        @JsonProperty("eventId")
        private String eventId;

        /** 事件源 */
        @JsonProperty("source")
        private String source;

        /** 事件关联操作对象ID */
        @JsonProperty("subject")
        private String subject;

        /** 事件类型 */
        @JsonProperty("eventType")
        private String eventType;

        /** 事件内容 */
        @JsonProperty("eventMessage")
        private String eventMessage;

        /** 创建时间 */
        @JsonProperty("createdTime")
        private String createdTime;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getEventId() {
            return this.eventId;
        }

        public void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public String getSubject() {
            return this.subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public String getEventType() {
            return this.eventType;
        }

        public void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public String getEventMessage() {
            return this.eventMessage;
        }

        public void setEventMessage(String eventMessage) {
            this.eventMessage = eventMessage;
        }

        public String getCreatedTime() {
            return this.createdTime;
        }

        public void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }
    }
}
