package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询指定集群下的CRD详情 */
public class CcseGetCRDApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseGetCRDApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterName}/apis/apiextensions.k8s.io/v1/customresourcedefinitions/{crdName}",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetCRDResponse send(Credential credential, GetCRDRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterName != null) {
            builder.replaceUrl("clusterName", request.clusterName);
            request.clusterName = null;
        }
        if (request.crdName != null) {
            builder.replaceUrl("crdName", request.crdName);
            request.crdName = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetCRDResponse.class);
    }

    public static class GetCRDRequest {
        /**
         * 集群id，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterName")
        private String clusterName;

        /** CRD名称 */
        @JsonProperty("crdName")
        private String crdName;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a><br>
         * 另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695"
         * target="_blank">地域和可用区</a>来了解资源池<br>
         * 获取：<span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getClusterName() {
            return this.clusterName;
        }

        public void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        public String getCrdName() {
            return this.crdName;
        }

        public void setCrdName(String crdName) {
            this.crdName = crdName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class GetCRDResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private String returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(String returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
