package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用该接口创建模板实例。 */
public class CcseDeployTemplateInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseDeployTemplateInstanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/namespaces/{namespaceName}/templateinstance",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DeployTemplateInstanceResponse send(
            Credential credential, DeployTemplateInstanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        if (request.namespaceName != null) {
            builder.replaceUrl("namespaceName", request.namespaceName);
            request.namespaceName = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DeployTemplateInstanceResponse.class);
    }

    public static class DeployTemplateInstanceRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /** 命名空间名称 */
        @JsonProperty("namespaceName")
        private String namespaceName;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422" target="_blank">云容器引擎资源池</a>
         * 另外您通过<a href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取：
         * <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81" target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** Chart名称 */
        @JsonProperty("chartName")
        private String chartName;

        /** Chart版本 */
        @JsonProperty("chartVersion")
        private String chartVersion;

        /**
         * 模板存放在镜像服务实例中的命名空间的ID，获取方法参见<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=44&api=10629&data=127&isNormal=1&vid=120"
         * target="_blank">查询HelmChart命名空间列表</a>
         */
        @JsonProperty("crNamespaceId")
        private Long crNamespaceId;

        /** 实例名 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 实例参数 */
        @JsonProperty("instanceValue")
        private String instanceValue;

        /**
         * 镜像服务实例仓库ID，获取方法参见<a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=44&api=10621&data=127&isNormal=1&vid=120"
         * target="_blank">查询镜像仓库列表</a>
         */
        @JsonProperty("repositoryId")
        private Long repositoryId;

        /** 实例安装超时时间 */
        @JsonProperty("timeout")
        private String timeout;

        /** 是否同步调用 */
        @JsonProperty("isSyncMode")
        private Boolean isSyncMode;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getNamespaceName() {
            return this.namespaceName;
        }

        public void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getChartName() {
            return this.chartName;
        }

        public void setChartName(String chartName) {
            this.chartName = chartName;
        }

        public String getChartVersion() {
            return this.chartVersion;
        }

        public void setChartVersion(String chartVersion) {
            this.chartVersion = chartVersion;
        }

        public Long getCrNamespaceId() {
            return this.crNamespaceId;
        }

        public void setCrNamespaceId(Long crNamespaceId) {
            this.crNamespaceId = crNamespaceId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getInstanceValue() {
            return this.instanceValue;
        }

        public void setInstanceValue(String instanceValue) {
            this.instanceValue = instanceValue;
        }

        public Long getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(Long repositoryId) {
            this.repositoryId = repositoryId;
        }

        public String getTimeout() {
            return this.timeout;
        }

        public void setTimeout(String timeout) {
            this.timeout = timeout;
        }

        public Boolean getIsSyncMode() {
            return this.isSyncMode;
        }

        public void setIsSyncMode(Boolean isSyncMode) {
            this.isSyncMode = isSyncMode;
        }
    }

    public static class DeployTemplateInstanceResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求id */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private Boolean returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Boolean returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
