package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

/** 创建节点 */
public class CcseCreatedNodesV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseCreatedNodesV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/nodes/create",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreatedNodesV2Response send(Credential credential, CreatedNodesV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreatedNodesV2Response.class);
    }

    public static class CreatedNodesV2Request {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 节点配置 */
        @JsonProperty("nodeMetadata")
        private CreatedNodesV2NodeMetadataRequest nodeMetadata;

        /** 创建节点数量 */
        @JsonProperty("count")
        private Integer count;

        /** 存储配置 */
        @JsonProperty("storageSpec")
        private CreatedNodesV2StorageSpecRequest storageSpec;

        /** 网络配置 */
        @JsonProperty("nicSpec")
        private CreatedNodesV2NicSpecRequest nicSpec;

        /** 节点高级配置 */
        @JsonProperty("advancedSpec")
        private CreatedNodesV2AdvancedSpecRequest advancedSpec;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public CreatedNodesV2NodeMetadataRequest getNodeMetadata() {
            return this.nodeMetadata;
        }

        public void setNodeMetadata(CreatedNodesV2NodeMetadataRequest nodeMetadata) {
            this.nodeMetadata = nodeMetadata;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public CreatedNodesV2StorageSpecRequest getStorageSpec() {
            return this.storageSpec;
        }

        public void setStorageSpec(CreatedNodesV2StorageSpecRequest storageSpec) {
            this.storageSpec = storageSpec;
        }

        public CreatedNodesV2NicSpecRequest getNicSpec() {
            return this.nicSpec;
        }

        public void setNicSpec(CreatedNodesV2NicSpecRequest nicSpec) {
            this.nicSpec = nicSpec;
        }

        public CreatedNodesV2AdvancedSpecRequest getAdvancedSpec() {
            return this.advancedSpec;
        }

        public void setAdvancedSpec(CreatedNodesV2AdvancedSpecRequest advancedSpec) {
            this.advancedSpec = advancedSpec;
        }
    }

    public static class CreatedNodesV2NodeMetadataRequest {
        /** 订单类型 1-包年包月 2-按需计费 */
        @JsonProperty("billMode")
        private String billMode;

        /** 订购时长，billMode为1必传，cycleType为MONTH时，cycleCount为1表示订购1个月 */
        @JsonProperty("cycleCount")
        private Integer cycleCount;

        /** 订购周期类型 MONTH-月 YEAR-年，billMode为1必传 */
        @JsonProperty("cycleType")
        private String cycleType;

        /** 是否自动续订 0-否 1-是，默认为0 */
        @JsonProperty("autoRenewStatus")
        private Integer autoRenewStatus;

        /**
         * 可用区信息。 可用区名称获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span><a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87&vid=81"
         * target="_blank">资源池可用区查询</a>
         */
        @JsonProperty("azNames")
        private List<String> azNames;

        /**
         * 容器运行时,仅支持containerd，您可查看<a href="https://www.ctyun.cn/document/10083472/10902208"
         * target="_blank">容器运行时说明</a>
         */
        @JsonProperty("containerRuntime")
        private String containerRuntime;

        /**
         * 节点规格，获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span><a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8327&data=87&isNormal=1&vid=81"
         * target="_blank">查询主机规格资源</a>
         */
        @JsonProperty("vmSpecName")
        private String vmSpecName;

        /**
         * 镜像类型，0-私有镜像，1-公有镜像。 您可查看<a href="https://www.ctyun.cn/document/10026730/10030151"
         * target="_blank">镜像概述</a>
         */
        @JsonProperty("imageType")
        private Integer imageType;

        /**
         * 镜像名称，公有镜像必填，镜像CPU架构需跟规格匹配。您可查看<a href="https://www.ctyun.cn/document/10083472/11004475"
         * target="_blank">节点规格和节点镜像</a>
         */
        @JsonProperty("imageName")
        private String imageName;

        /**
         * 镜像ID，私有镜像必填，镜像CPU架构需跟规格匹配。您可以查看<a href="https://www.ctyun.cn/document/10083472/11004475"
         * target="_blank">节点规格和节点镜像</a> <span style="background-color: rgb(97, 175, 254);color:
         * rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=23&amp;api=4765&amp;data=89"
         * target="_blank">创建私有镜像（云主机系统盘）</a> <span style="background-color: rgb(97, 175,
         * 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=23&amp;api=5230&amp;data=89"
         * target="_blank">创建私有镜像（云主机数据盘）</a> 注：同一镜像名称在不同资源池的镜像ID是不同的，调用前需确认镜像ID是否归属当前资源池
         */
        @JsonProperty("imageUuid")
        private String imageUuid;

        /** 云主机密码登录类型：secretPair：密钥对；password：密码 */
        @JsonProperty("loginType")
        private String loginType;

        /**
         * 云主机或物理机，用户登录密码，如果loginType=password，这该项为必填项，满足以下规则： 物理机：用户密码，满足以下规则：长度在8～30个字符；
         * 必须包含大小写字母和（至少一个数字或者特殊字符）； 特殊符号可选：()`~!@#$%&*_-+=\ 云主机：长度在8～30个字符；
         * 必须包含大写字母、小写字母、数字以及特殊符号中的三项； 特殊符号可选：()`-!@#$%^&*_-+=｜{}[]:;'<>,.?/且不能以斜线号 / 开头；
         * 不能包含3个及以上连续字符； 创建节点时password字段可选择加密，具体加密方法请参见<a
         * href="https://www.ctyun.cn/document/10083472/11002096"
         * target="_blank">password字段加密的方法</a>
         */
        @JsonProperty("password")
        private String password;

        /**
         * 密钥对名称，如果loginType=secretPair，物理机该项为必填项，您可以查看密钥对来了解密钥对相关内容 获取： <span
         * style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81"
         * target="_blank">查询一个或多个密钥对</a> <span style="background-color: rgb(97, 175, 254);color:
         * rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81"
         * target="_blank">创建一对SSH密钥对</a>
         */
        @JsonProperty("keyName")
        private String keyName;

        /**
         * 密钥对ID，如果loginType=secretPair，弹性云主机该项为必填项。您可以查看密钥对来了解密钥对相关内容 获取： <span
         * style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81"
         * target="_blank">查询一个或多个密钥对</a> <span style="background-color: rgb(97, 175, 254);color:
         * rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81"
         * target="_blank">创建一对SSH密钥对</a>
         */
        @JsonProperty("keyPairId")
        private String keyPairId;

        public String getBillMode() {
            return this.billMode;
        }

        public void setBillMode(String billMode) {
            this.billMode = billMode;
        }

        public Integer getCycleCount() {
            return this.cycleCount;
        }

        public void setCycleCount(Integer cycleCount) {
            this.cycleCount = cycleCount;
        }

        public String getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(String cycleType) {
            this.cycleType = cycleType;
        }

        public Integer getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(Integer autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }

        public List<String> getAzNames() {
            return this.azNames;
        }

        public void setAzNames(List<String> azNames) {
            this.azNames = azNames;
        }

        public String getContainerRuntime() {
            return this.containerRuntime;
        }

        public void setContainerRuntime(String containerRuntime) {
            this.containerRuntime = containerRuntime;
        }

        public String getVmSpecName() {
            return this.vmSpecName;
        }

        public void setVmSpecName(String vmSpecName) {
            this.vmSpecName = vmSpecName;
        }

        public Integer getImageType() {
            return this.imageType;
        }

        public void setImageType(Integer imageType) {
            this.imageType = imageType;
        }

        public String getImageName() {
            return this.imageName;
        }

        public void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public String getImageUuid() {
            return this.imageUuid;
        }

        public void setImageUuid(String imageUuid) {
            this.imageUuid = imageUuid;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyPairId() {
            return this.keyPairId;
        }

        public void setKeyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
        }
    }

    public static class CreatedNodesV2StorageSpecRequest {
        /** 系统盘大小，单位是G 系统盘取值范围： 1、裸金属：取值范围[100,2040] 2、云主机：取值范围[镜像磁盘大小,2040] */
        @JsonProperty("sysDiskSize")
        private Integer sysDiskSize;

        /**
         * 系统盘规格，云硬盘类型，取值范围： SATA：普通IO， SAS：高IO， SSD：超高IO 您可以查看<a
         * href="https://www.ctyun.cn/document/10027696/10162918"
         * target="_blank">磁盘类型及性能介绍</a>磁盘类型相关信息
         */
        @JsonProperty("sysDiskType")
        private String sysDiskType;

        /** 数据盘信息，当vmSpecName为裸金属规格时，需确认该裸金属是否支持数据盘云盘。同一云主机下最多可挂载7块数据盘 */
        @JsonProperty("dataDisks")
        private List<CreatedNodesV2StorageSpecDataDisksRequest> dataDisks;

        public Integer getSysDiskSize() {
            return this.sysDiskSize;
        }

        public void setSysDiskSize(Integer sysDiskSize) {
            this.sysDiskSize = sysDiskSize;
        }

        public String getSysDiskType() {
            return this.sysDiskType;
        }

        public void setSysDiskType(String sysDiskType) {
            this.sysDiskType = sysDiskType;
        }

        public List<CreatedNodesV2StorageSpecDataDisksRequest> getDataDisks() {
            return this.dataDisks;
        }

        public void setDataDisks(List<CreatedNodesV2StorageSpecDataDisksRequest> dataDisks) {
            this.dataDisks = dataDisks;
        }
    }

    public static class CreatedNodesV2NicSpecRequest {
        /**
         * 安全组ID，如果不填则保持和集群的一致 安全组ID 您可以查看<a href="https://www.ctyun.cn/document/10026755/10028520"
         * target="_blank">安全组概述</a>了解安全组相关信息 获取： <span style="background-color: rgb(73, 204,
         * 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&api=4817&data=94&vid=88"
         * target="_blank">查询用户安全组列表</a> 注：在多可用区类型资源池下，安全组ID通常以“sg-”开头，非多可用区类型资源池安全组ID为uuid格式
         */
        @JsonProperty("securityGroupId")
        private String securityGroupId;

        /**
         * 子网ID，如果不填则保持和集群的一致 您可以查看<a href="https://www.ctyun.cn/document/10026755/10098380"
         * target="_blank">基本概念</a>来查找子网的相关定义 获取： <span style="background-color: rgb(73, 204,
         * 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span><a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=18&amp;api=8659&amp;data=94"
         * target="_blank">查询子网列表</a> 注：在多可用区类型资源池下，subnetID通常以“subnet-”开头，非多可用区类型资源池subnetID为uuid格式
         */
        @JsonProperty("subnetUuid")
        private String subnetUuid;

        public String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        public String getSubnetUuid() {
            return this.subnetUuid;
        }

        public void setSubnetUuid(String subnetUuid) {
            this.subnetUuid = subnetUuid;
        }
    }

    public static class CreatedNodesV2AdvancedSpecRequest {
        /** 部署后执行自定义脚本，base64编码 */
        @JsonProperty("visibilityPostHostScript")
        private String visibilityPostHostScript;

        /** 部署前执行自定义脚本，base64编码 */
        @JsonProperty("visibilityHostScript")
        private String visibilityHostScript;

        /** K8S节点标签 */
        @JsonProperty("labels")
        private Map<String,String> labels;

        /** K8S节点注解 */
        @JsonProperty("annotations")
        private Map<String,String> annotations;

        /**
         * 节点污点，格式为
         * [{\"key\":\"{key}\",\"value\":\"{value}\",\"effect\":\"{effect}\"}]，上述的{key}、{value}、{effect}替换为所需字段。effect枚举包括NoSchedule、PreferNoSchedule、NoExecute
         */
        @JsonProperty("taints")
        private List<CreatedNodesV2AdvancedSpecTaintsRequest> taints;

        /** Kubelet自定义参数 */
        @JsonProperty("kubeletArgs")
        private CreatedNodesV2AdvancedSpecKubeletArgsRequest kubeletArgs;

        /** 是否同步集群标签。默认是false。如果为true，则同步以当前集群标签为基准的快照。 */
        @JsonProperty("isSyncClusterResourceLabels")
        private Boolean isSyncClusterResourceLabels;

        /** 云主机资源标签 */
        @JsonProperty("resourceLabels")
        private Map<String,String> resourceLabels;

        /** kubelet数据目录。该参数可以自定义指定在/data下的子目录，用于kubelet数据目录。该参数由白名单控制 */
        @JsonProperty("kubeletDirectory")
        private String kubeletDirectory;

        /** 容器数据目录。该参数可以自定义指定在/data下的子目录，用于容器数据目录。该参数由白名单控制 */
        @JsonProperty("containerDataDirectory")
        private String containerDataDirectory;

        /** 是否启用主机组 */
        @JsonProperty("useAffinityGroup")
        private Boolean useAffinityGroup;

        /**
         * 云主机组ID，获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8324&data=87&vid=81"
         * target="_blank">查询云主机组列表或者详情</a> <span style="background-color: rgb(97, 175, 254);color:
         * rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8316&data=87&vid=81"
         * target="_blank">创建云主机组</a>
         */
        @JsonProperty("affinityGroupUuid")
        private String affinityGroupUuid;

        public String getVisibilityPostHostScript() {
            return this.visibilityPostHostScript;
        }

        public void setVisibilityPostHostScript(String visibilityPostHostScript) {
            this.visibilityPostHostScript = visibilityPostHostScript;
        }

        public String getVisibilityHostScript() {
            return this.visibilityHostScript;
        }

        public void setVisibilityHostScript(String visibilityHostScript) {
            this.visibilityHostScript = visibilityHostScript;
        }

        public Map<String,String> getLabels() {
            return this.labels;
        }

        public void setLabels(Map<String,String> labels) {
            this.labels = labels;
        }

        public Map<String,String> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Map<String,String> annotations) {
            this.annotations = annotations;
        }

        public List<CreatedNodesV2AdvancedSpecTaintsRequest> getTaints() {
            return this.taints;
        }

        public void setTaints(List<CreatedNodesV2AdvancedSpecTaintsRequest> taints) {
            this.taints = taints;
        }

        public CreatedNodesV2AdvancedSpecKubeletArgsRequest getKubeletArgs() {
            return this.kubeletArgs;
        }

        public void setKubeletArgs(CreatedNodesV2AdvancedSpecKubeletArgsRequest kubeletArgs) {
            this.kubeletArgs = kubeletArgs;
        }

        public Boolean getIsSyncClusterResourceLabels() {
            return this.isSyncClusterResourceLabels;
        }

        public void setIsSyncClusterResourceLabels(Boolean isSyncClusterResourceLabels) {
            this.isSyncClusterResourceLabels = isSyncClusterResourceLabels;
        }

        public Map<String,String> getResourceLabels() {
            return this.resourceLabels;
        }

        public void setResourceLabels(Map<String,String> resourceLabels) {
            this.resourceLabels = resourceLabels;
        }

        public String getKubeletDirectory() {
            return this.kubeletDirectory;
        }

        public void setKubeletDirectory(String kubeletDirectory) {
            this.kubeletDirectory = kubeletDirectory;
        }

        public String getContainerDataDirectory() {
            return this.containerDataDirectory;
        }

        public void setContainerDataDirectory(String containerDataDirectory) {
            this.containerDataDirectory = containerDataDirectory;
        }

        public Boolean getUseAffinityGroup() {
            return this.useAffinityGroup;
        }

        public void setUseAffinityGroup(Boolean useAffinityGroup) {
            this.useAffinityGroup = useAffinityGroup;
        }

        public String getAffinityGroupUuid() {
            return this.affinityGroupUuid;
        }

        public void setAffinityGroupUuid(String affinityGroupUuid) {
            this.affinityGroupUuid = affinityGroupUuid;
        }
    }

    public static class CreatedNodesV2StorageSpecDataDisksRequest {
        /**
         * 数据盘规格名称，取值范围： SATA：普通IO， SAS：高IO， SSD：超高IO 您可以查看<a
         * href="https://www.ctyun.cn/document/10027696/10162918"
         * target="_blank">磁盘类型及性能介绍</a>磁盘类型相关信息
         */
        @JsonProperty("diskSpecName")
        private String diskSpecName;

        /** 数据盘大小，单位为G，取值范围[10,20000] */
        @JsonProperty("size")
        private Integer size;

        public String getDiskSpecName() {
            return this.diskSpecName;
        }

        public void setDiskSpecName(String diskSpecName) {
            this.diskSpecName = diskSpecName;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }
    }

    public static class CreatedNodesV2AdvancedSpecLabelsRequest {}

    public static class CreatedNodesV2AdvancedSpecAnnotationsRequest {}

    public static class CreatedNodesV2AdvancedSpecTaintsRequest {
        /** 键 */
        @JsonProperty("key")
        private String key;

        /** 值 */
        @JsonProperty("value")
        private String value;

        /** 策略 */
        @JsonProperty("effect")
        private String effect;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }
    }

    public static class CreatedNodesV2AdvancedSpecKubeletArgsRequest {
        /** 请求至kube-apiserver的QPS配置 */
        @JsonProperty("kubeAPIQPS")
        private Integer kubeAPIQPS;

        /** 请求至kube-apiserver的Burst配置 */
        @JsonProperty("kubeAPIBurst")
        private Integer kubeAPIBurst;

        /** kubelet管理的pod上限 */
        @JsonProperty("maxPods")
        private Integer maxPods;

        /** 每秒钟可以执行的镜像仓库拉取操作限值 */
        @JsonProperty("registryPullQPS")
        private Integer registryPullQPS;

        /** 每秒钟可以执行的镜像仓库拉取操作限值 */
        @JsonProperty("registryBurst")
        private Integer registryBurst;

        /** 限制Pod中的进程数 */
        @JsonProperty("podPidsLimit")
        private Integer podPidsLimit;

        /** 事件创建QPS限制 */
        @JsonProperty("eventRecordQPS")
        private Integer eventRecordQPS;

        /** 事件创建的个数的突发峰值上限 */
        @JsonProperty("eventBurst")
        private Integer eventBurst;

        /** 拓扑管理策略的资源对齐粒度 */
        @JsonProperty("topologyManagerScope")
        private String topologyManagerScope;

        /** 是否为设置了CPU限制的容器实施CPU CFS配额约束,默认值为true */
        @JsonProperty("cpuCFSQuota")
        private Boolean cpuCFSQuota;

        public Integer getKubeAPIQPS() {
            return this.kubeAPIQPS;
        }

        public void setKubeAPIQPS(Integer kubeAPIQPS) {
            this.kubeAPIQPS = kubeAPIQPS;
        }

        public Integer getKubeAPIBurst() {
            return this.kubeAPIBurst;
        }

        public void setKubeAPIBurst(Integer kubeAPIBurst) {
            this.kubeAPIBurst = kubeAPIBurst;
        }

        public Integer getMaxPods() {
            return this.maxPods;
        }

        public void setMaxPods(Integer maxPods) {
            this.maxPods = maxPods;
        }

        public Integer getRegistryPullQPS() {
            return this.registryPullQPS;
        }

        public void setRegistryPullQPS(Integer registryPullQPS) {
            this.registryPullQPS = registryPullQPS;
        }

        public Integer getRegistryBurst() {
            return this.registryBurst;
        }

        public void setRegistryBurst(Integer registryBurst) {
            this.registryBurst = registryBurst;
        }

        public Integer getPodPidsLimit() {
            return this.podPidsLimit;
        }

        public void setPodPidsLimit(Integer podPidsLimit) {
            this.podPidsLimit = podPidsLimit;
        }

        public Integer getEventRecordQPS() {
            return this.eventRecordQPS;
        }

        public void setEventRecordQPS(Integer eventRecordQPS) {
            this.eventRecordQPS = eventRecordQPS;
        }

        public Integer getEventBurst() {
            return this.eventBurst;
        }

        public void setEventBurst(Integer eventBurst) {
            this.eventBurst = eventBurst;
        }

        public String getTopologyManagerScope() {
            return this.topologyManagerScope;
        }

        public void setTopologyManagerScope(String topologyManagerScope) {
            this.topologyManagerScope = topologyManagerScope;
        }

        public Boolean getCpuCFSQuota() {
            return this.cpuCFSQuota;
        }

        public void setCpuCFSQuota(Boolean cpuCFSQuota) {
            this.cpuCFSQuota = cpuCFSQuota;
        }
    }

    public static class CreatedNodesV2AdvancedSpecResourceLabelsRequest {}

    public static class CreatedNodesV2Response {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private Boolean returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Boolean returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
