package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口获取集群升级检查结果 */
public class CcseClusterUpgradePrecheckApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseClusterUpgradePrecheckApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/cce/clusters/{clusterId}/upgrade/precheck",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ClusterUpgradePrecheckResponse send(
            Credential credential, ClusterUpgradePrecheckRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.checklistName != null) {
            ctReq.addParam("checklistName", request.checklistName);
            request.checklistName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ClusterUpgradePrecheckResponse.class);
    }

    public static class ClusterUpgradePrecheckRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 集群升级检查项，目前支持的检查项及含义如下 ClusterComponentChecklist：集群组件检查
         * ClusterConfigurationChecklist：集群配置检查 ClusterResourceChecklist：集群资源检查
         */
        @JsonProperty("checklistName")
        private String checklistName;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getChecklistName() {
            return this.checklistName;
        }

        public void setChecklistName(String checklistName) {
            this.checklistName = checklistName;
        }
    }

    public static class ClusterUpgradePrecheckResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 响应对象 */
        @JsonProperty("returnObj")
        private ClusterUpgradePrecheckReturnObjResponse returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ClusterUpgradePrecheckReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ClusterUpgradePrecheckReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ClusterUpgradePrecheckReturnObjResponse {
        /** 集群升级中的错误信息 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        /** 检查状态：checking 检查中；completed 检查完成 */
        @JsonProperty("checkStatus")
        private String checkStatus;

        /** 检查结果 */
        @JsonProperty("checkEntryResult")
        private List<ClusterUpgradePrecheckReturnObjCheckEntryResultResponse> checkEntryResult;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getCheckStatus() {
            return this.checkStatus;
        }

        public void setCheckStatus(String checkStatus) {
            this.checkStatus = checkStatus;
        }

        public List<ClusterUpgradePrecheckReturnObjCheckEntryResultResponse> getCheckEntryResult() {
            return this.checkEntryResult;
        }

        public void setCheckEntryResult(
                List<ClusterUpgradePrecheckReturnObjCheckEntryResultResponse> checkEntryResult) {
            this.checkEntryResult = checkEntryResult;
        }
    }

    public static class ClusterUpgradePrecheckReturnObjCheckEntryResultResponse {
        /** 检查项名称 */
        @JsonProperty("entryName")
        private String entryName;

        /** 检查项所属分组 */
        @JsonProperty("entryGroupName")
        private String entryGroupName;

        /** 正常节点实例检查结果 */
        @JsonProperty("normalInstanceResult")
        private List<ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultResponse>
                normalInstanceResult;

        /** 异常节点实例检查结果 */
        @JsonProperty("errorInstanceResult")
        private List<ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultResponse>
                errorInstanceResult;

        /** 检查汇总 */
        @JsonProperty("checkSummary")
        private ClusterUpgradePrecheckReturnObjCheckEntryResultCheckSummaryResponse checkSummary;

        public String getEntryName() {
            return this.entryName;
        }

        public void setEntryName(String entryName) {
            this.entryName = entryName;
        }

        public String getEntryGroupName() {
            return this.entryGroupName;
        }

        public void setEntryGroupName(String entryGroupName) {
            this.entryGroupName = entryGroupName;
        }

        public List<ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultResponse>
                getNormalInstanceResult() {
            return this.normalInstanceResult;
        }

        public void setNormalInstanceResult(
                List<ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultResponse>
                        normalInstanceResult) {
            this.normalInstanceResult = normalInstanceResult;
        }

        public List<ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultResponse>
                getErrorInstanceResult() {
            return this.errorInstanceResult;
        }

        public void setErrorInstanceResult(
                List<ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultResponse>
                        errorInstanceResult) {
            this.errorInstanceResult = errorInstanceResult;
        }

        public ClusterUpgradePrecheckReturnObjCheckEntryResultCheckSummaryResponse
                getCheckSummary() {
            return this.checkSummary;
        }

        public void setCheckSummary(
                ClusterUpgradePrecheckReturnObjCheckEntryResultCheckSummaryResponse checkSummary) {
            this.checkSummary = checkSummary;
        }
    }

    public static
    class ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultResponse {
        /** 节点实例id */
        @JsonProperty("instanceId")
        private String instanceId;

        /** 节点实例名称 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 检查结果 */
        @JsonProperty("checkpointResults")
        private
        ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultCheckpointResultsResponse
                checkpointResults;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public
        ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultCheckpointResultsResponse
                getCheckpointResults() {
            return this.checkpointResults;
        }

        public void setCheckpointResults(
                ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultCheckpointResultsResponse
                        checkpointResults) {
            this.checkpointResults = checkpointResults;
        }
    }

    public static class ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultResponse {
        /** 节点实例id */
        @JsonProperty("instanceId")
        private String instanceId;

        /** 节点实例名称 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 检查结果 */
        @JsonProperty("checkpointResults")
        private
        ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultCheckpointResultsResponse
                checkpointResults;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public
        ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultCheckpointResultsResponse
                getCheckpointResults() {
            return this.checkpointResults;
        }

        public void setCheckpointResults(
                ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultCheckpointResultsResponse
                        checkpointResults) {
            this.checkpointResults = checkpointResults;
        }
    }

    public static class ClusterUpgradePrecheckReturnObjCheckEntryResultCheckSummaryResponse {
        /** 正常数量 */
        @JsonProperty("normalCount")
        private Integer normalCount;

        /** 错误数量 */
        @JsonProperty("errorCount")
        private Integer errorCount;

        /** 检查进度 */
        @JsonProperty("process")
        private String process;

        /** 结果代码 */
        @JsonProperty("code")
        private String code;

        public Integer getNormalCount() {
            return this.normalCount;
        }

        public void setNormalCount(Integer normalCount) {
            this.normalCount = normalCount;
        }

        public Integer getErrorCount() {
            return this.errorCount;
        }

        public void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        public String getProcess() {
            return this.process;
        }

        public void setProcess(String process) {
            this.process = process;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }
    }

    public static
    class ClusterUpgradePrecheckReturnObjCheckEntryResultNormalInstanceResultCheckpointResultsResponse {
        /** 消息级别 */
        @JsonProperty("messageLevel")
        private String messageLevel;

        /** 检查内容 */
        @JsonProperty("checkpointName")
        private String checkpointName;

        /** 修复建议 */
        @JsonProperty("adviseCode")
        private String adviseCode;

        /** 结果 */
        @JsonProperty("messageCode")
        private String messageCode;

        /** 影响 */
        @JsonProperty("affectCode")
        private String affectCode;

        public String getMessageLevel() {
            return this.messageLevel;
        }

        public void setMessageLevel(String messageLevel) {
            this.messageLevel = messageLevel;
        }

        public String getCheckpointName() {
            return this.checkpointName;
        }

        public void setCheckpointName(String checkpointName) {
            this.checkpointName = checkpointName;
        }

        public String getAdviseCode() {
            return this.adviseCode;
        }

        public void setAdviseCode(String adviseCode) {
            this.adviseCode = adviseCode;
        }

        public String getMessageCode() {
            return this.messageCode;
        }

        public void setMessageCode(String messageCode) {
            this.messageCode = messageCode;
        }

        public String getAffectCode() {
            return this.affectCode;
        }

        public void setAffectCode(String affectCode) {
            this.affectCode = affectCode;
        }
    }

    public static
    class ClusterUpgradePrecheckReturnObjCheckEntryResultErrorInstanceResultCheckpointResultsResponse {
        /** 消息级别 */
        @JsonProperty("messageLevel")
        private String messageLevel;

        /** 检查内容 */
        @JsonProperty("checkpointName")
        private String checkpointName;

        /** 修复建议 */
        @JsonProperty("adviseCode")
        private String adviseCode;

        /** 结果 */
        @JsonProperty("messageCode")
        private String messageCode;

        /** 影响 */
        @JsonProperty("affectCode")
        private String affectCode;

        public String getMessageLevel() {
            return this.messageLevel;
        }

        public void setMessageLevel(String messageLevel) {
            this.messageLevel = messageLevel;
        }

        public String getCheckpointName() {
            return this.checkpointName;
        }

        public void setCheckpointName(String checkpointName) {
            this.checkpointName = checkpointName;
        }

        public String getAdviseCode() {
            return this.adviseCode;
        }

        public void setAdviseCode(String adviseCode) {
            this.adviseCode = adviseCode;
        }

        public String getMessageCode() {
            return this.messageCode;
        }

        public void setMessageCode(String messageCode) {
            this.messageCode = messageCode;
        }

        public String getAffectCode() {
            return this.affectCode;
        }

        public void setAffectCode(String affectCode) {
            this.affectCode = affectCode;
        }
    }
}
