package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用该接口批量删除节点池。 */
public class CcseBatchDeleteNodePoolApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseBatchDeleteNodePoolApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "DELETE",
                        "/v2/cce/clusters/{clusterId}/nodepool/batchdelete",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BatchDeleteNodePoolResponse send(
            Credential credential, BatchDeleteNodePoolRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BatchDeleteNodePoolResponse.class);
    }

    public static class BatchDeleteNodePoolRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 节点池名称列表 */
        @JsonProperty("nodePoolNames")
        private List<String> nodePoolNames;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getNodePoolNames() {
            return this.nodePoolNames;
        }

        public void setNodePoolNames(List<String> nodePoolNames) {
            this.nodePoolNames = nodePoolNames;
        }
    }

    public static class BatchDeleteNodePoolResponse {
        /** 状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 提示信息 */
        @JsonProperty("message")
        private String message;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private BatchDeleteNodePoolReturnObjResponse returnObj;

        /** 错误码 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public BatchDeleteNodePoolReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BatchDeleteNodePoolReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class BatchDeleteNodePoolReturnObjResponse {
        /** 批量操作成功列表 */
        @JsonProperty("successList")
        private List<String> successList;

        /** 批量操作失败列表 */
        @JsonProperty("failedList")
        private List<String> failedList;

        /** 批量操作数据个数 */
        @JsonProperty("total")
        private Integer total;

        /** 批量操作成功数据个数 */
        @JsonProperty("successTotal")
        private Integer successTotal;

        /** 批量操作失败数据个数 */
        @JsonProperty("failedTotal")
        private Integer failedTotal;

        public List<String> getSuccessList() {
            return this.successList;
        }

        public void setSuccessList(List<String> successList) {
            this.successList = successList;
        }

        public List<String> getFailedList() {
            return this.failedList;
        }

        public void setFailedList(List<String> failedList) {
            this.failedList = failedList;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSuccessTotal() {
            return this.successTotal;
        }

        public void setSuccessTotal(Integer successTotal) {
            this.successTotal = successTotal;
        }

        public Integer getFailedTotal() {
            return this.failedTotal;
        }

        public void setFailedTotal(Integer failedTotal) {
            this.failedTotal = failedTotal;
        }
    }
}
