package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

/** 调用该接口纳管节点。 */
public class CcseAttachClusterNodesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CcseAttachClusterNodesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/cce/clusters/{clusterId}/nodes/attach",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AttachClusterNodesResponse send(Credential credential, AttachClusterNodesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        if (request.clusterId != null) {
            builder.replaceUrl("clusterId", request.clusterId);
            request.clusterId = null;
        }
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AttachClusterNodesResponse.class);
    }

    public static class AttachClusterNodesRequest {
        /**
         * 集群ID，获取方式请参见<a href="https://www.ctyun.cn/document/10083472/11002105"
         * target="_blank">如何获取接口URI中参数</a>。
         */
        @JsonProperty("clusterId")
        private String clusterId;

        /**
         * 资源池ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004422"
         * target="_blank">云容器引擎资源池</a> 另外您通过<a
         * href="https://www.ctyun.cn/document/10026730/10028695" target="_blank">地域和可用区</a>来了解资源池
         * 获取： <span style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding:
         * 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5851&data=87&vid=81"
         * target="_blank">资源池列表查询</a>
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 云主机ECS 信息 */
        @JsonProperty("instances")
        private List<AttachClusterNodesInstancesRequest> instances;

        /** 默认ecs，值为：弹性云主机则是：ecs ；物理机则是：ebm */
        @JsonProperty("vmType")
        private String vmType;

        /** 容器运行时，目前仅支持 CONTAINERD */
        @JsonProperty("runtime")
        private String runtime;

        /**
         * 镜像类型，0-私有镜像，1-公有镜像。 您可查看<a href="https://www.ctyun.cn/document/10026730/10030151"
         * target="_blank">镜像概述</a>
         */
        @JsonProperty("imageType")
        private Integer imageType;

        /**
         * 镜像ID，您可以查看<a href="https://www.ctyun.cn/document/10083472/11004475"
         * target="_blank">节点规格和节点镜像</a> <span style="background-color: rgb(97, 175, 254);color:
         * rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=23&amp;api=4765&amp;data=89"
         * target="_blank">创建私有镜像（云主机系统盘）</a> <span style="background-color: rgb(97, 175,
         * 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=23&amp;api=5230&amp;data=89"
         * target="_blank">创建私有镜像（云主机数据盘）</a> 注：同一镜像名称在不同资源池的镜像ID是不同的，调用前需确认镜像ID是否归属当前资源池
         */
        @JsonProperty("imageUuid")
        private String imageUuid;

        /** 主机登录方式： password：密码，secretPair：密钥对 */
        @JsonProperty("loginType")
        private String loginType;

        /**
         * 云主机或物理机，用户登录密码，如果loginType=password，这该项为必填项，满足以下规则： 物理机：用户密码，满足以下规则：长度在8～30个字符；
         * 必须包含大小写字母和（至少一个数字或者特殊字符）； 特殊符号可选：()`~!@#$%&*_-+=\ 云主机：长度在8～30个字符；
         * 必须包含大写字母、小写字母、数字以及特殊符号中的三项； 特殊符号可选：()`-!@#$%^&*_-+=｜{}[]:;'<>,.?/且不能以斜线号 / 开头；
         * 不能包含3个及以上连续字符； 纳管节点时password字段可选择加密，具体加密方法请参见<a
         * href="https://www.ctyun.cn/document/10083472/11002096"
         * target="_blank">password字段加密的方法</a>
         */
        @JsonProperty("password")
        private String password;

        /**
         * 密钥对名称，如果loginType=secretPair，物理机该项为必填项，您可以查看密钥对来了解密钥对相关内容 获取： <span
         * style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81"
         * target="_blank">查询一个或多个密钥对</a> <span style="background-color: rgb(97, 175, 254);color:
         * rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81"
         * target="_blank">创建一对SSH密钥对</a>
         */
        @JsonProperty("keyName")
        private String keyName;

        /**
         * 密钥对ID，如果loginType=secretPair，弹性云主机该项为必填项。您可以查看密钥对来了解密钥对相关内容 获取： <span
         * style="background-color: rgb(73, 204, 144);color: rgb(255,255,255);padding: 2px;
         * margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8342&data=87&vid=81">查询一个或多个密钥对</a>
         * <span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px;
         * margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=8344&data=87&vid=81"
         * target="_blank">创建一对SSH密钥对</a>
         */
        @JsonProperty("keyPairId")
        private String keyPairId;

        /** K8S节点标签 */
        @JsonProperty("labels")
        private Map<String,String> labels;

        /** K8S节点注解 */
        @JsonProperty("annotations")
        private Map<String,String> annotations;

        /**
         * 节点污点，格式为
         * [{\"key\":\"{key}\",\"value\":\"{value}\",\"effect\":\"{effect}\"}]，上述的{key}、{value}、{effect}替换为所需字段。effect枚举包括NoSchedule、PreferNoSchedule、NoExecute
         */
        @JsonProperty("taints")
        private List<AttachClusterNodesTaintsRequest> taints;

        /** 部署后执行自定义脚本 （输入的值需要经过Base64编码，方法如下：echo -n "待编码内容" \ */
        @JsonProperty("visibilityPostHostScript")
        private String visibilityPostHostScript;

        /** 部署前执行自定义脚本（输入的值需要经过Base64编码，方法如下：echo -n "待编码内容" \ */
        @JsonProperty("visibilityHostScript")
        private String visibilityHostScript;

        /** Kubelet自定义参数 */
        @JsonProperty("kubeletArgs")
        private AttachClusterNodesKubeletArgsRequest kubeletArgs;

        /** 是否同步集群标签。默认是false。如果为true，则同步以当前集群标签为基准的快照。 */
        @JsonProperty("isSyncClusterResourceLabels")
        private Boolean isSyncClusterResourceLabels;

        /** 云主机资源标签 */
        @JsonProperty("resourceLabels")
        private Map<String,String> resourceLabels;

        /** kubelet数据目录。该参数可以自定义指定在/data下的子目录，用于kubelet数据目录。该参数由白名单控制 */
        @JsonProperty("kubeletDirectory")
        private String kubeletDirectory;

        /** 容器数据目录。该参数可以自定义指定在/data下的子目录，用于容器数据目录。该参数由白名单控制 */
        @JsonProperty("containerDataDirectory")
        private String containerDataDirectory;

        public String getClusterId() {
            return this.clusterId;
        }

        public void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<AttachClusterNodesInstancesRequest> getInstances() {
            return this.instances;
        }

        public void setInstances(List<AttachClusterNodesInstancesRequest> instances) {
            this.instances = instances;
        }

        public String getVmType() {
            return this.vmType;
        }

        public void setVmType(String vmType) {
            this.vmType = vmType;
        }

        public String getRuntime() {
            return this.runtime;
        }

        public void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        public Integer getImageType() {
            return this.imageType;
        }

        public void setImageType(Integer imageType) {
            this.imageType = imageType;
        }

        public String getImageUuid() {
            return this.imageUuid;
        }

        public void setImageUuid(String imageUuid) {
            this.imageUuid = imageUuid;
        }

        public String getLoginType() {
            return this.loginType;
        }

        public void setLoginType(String loginType) {
            this.loginType = loginType;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getKeyName() {
            return this.keyName;
        }

        public void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        public String getKeyPairId() {
            return this.keyPairId;
        }

        public void setKeyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
        }

        public Map<String,String> getLabels() {
            return this.labels;
        }

        public void setLabels(Map<String,String> labels) {
            this.labels = labels;
        }

        public Map<String,String> getAnnotations() {
            return this.annotations;
        }

        public void setAnnotations(Map<String,String> annotations) {
            this.annotations = annotations;
        }

        public List<AttachClusterNodesTaintsRequest> getTaints() {
            return this.taints;
        }

        public void setTaints(List<AttachClusterNodesTaintsRequest> taints) {
            this.taints = taints;
        }

        public String getVisibilityPostHostScript() {
            return this.visibilityPostHostScript;
        }

        public void setVisibilityPostHostScript(String visibilityPostHostScript) {
            this.visibilityPostHostScript = visibilityPostHostScript;
        }

        public String getVisibilityHostScript() {
            return this.visibilityHostScript;
        }

        public void setVisibilityHostScript(String visibilityHostScript) {
            this.visibilityHostScript = visibilityHostScript;
        }

        public AttachClusterNodesKubeletArgsRequest getKubeletArgs() {
            return this.kubeletArgs;
        }

        public void setKubeletArgs(AttachClusterNodesKubeletArgsRequest kubeletArgs) {
            this.kubeletArgs = kubeletArgs;
        }

        public Boolean getIsSyncClusterResourceLabels() {
            return this.isSyncClusterResourceLabels;
        }

        public void setIsSyncClusterResourceLabels(Boolean isSyncClusterResourceLabels) {
            this.isSyncClusterResourceLabels = isSyncClusterResourceLabels;
        }

        public Map<String,String> getResourceLabels() {
            return this.resourceLabels;
        }

        public void setResourceLabels(Map<String,String> resourceLabels) {
            this.resourceLabels = resourceLabels;
        }

        public String getKubeletDirectory() {
            return this.kubeletDirectory;
        }

        public void setKubeletDirectory(String kubeletDirectory) {
            this.kubeletDirectory = kubeletDirectory;
        }

        public String getContainerDataDirectory() {
            return this.containerDataDirectory;
        }

        public void setContainerDataDirectory(String containerDataDirectory) {
            this.containerDataDirectory = containerDataDirectory;
        }
    }

    public static class AttachClusterNodesInstancesRequest {
        /**
         * 云主机ID，您可以查看<a href="https://www.ctyun.cn/products/ecs"
         * target="_blank">弹性云主机</a>了解云主机的相关信息 获取： <span style="background-color: rgb(73, 204,
         * 144);color: rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=8309&amp;data=87">查询云主机列表</a>
         * <span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px;
         * margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=8281&amp;data=87"
         * target="_blank">创建一台按量付费或包年包月的云主机</a> <span style="background-color: rgb(97, 175,
         * 254);color: rgb(255,255,255);padding: 2px; margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&amp;api=8282&amp;data=87">批量创建按量付费或包年包月云主机</a>
         *
         * <p>物理机 instanceUUID，获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=6941&data=97&isNormal=1&vid=91">批量查询物理机</a>
         * <span style="background-color: rgb(97, 175, 254);color: rgb(255,255,255);padding: 2px;
         * margin:2px">创</span> <a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=16&api=6942&data=97&isNormal=1&vid=91">物理机创建</a>
         */
        @JsonProperty("instanceId")
        private String instanceId;

        /**
         * 可用区名称，纳管是物理机，此项必填，可用区信息可用区名称获取： <span style="background-color: rgb(73, 204, 144);color:
         * rgb(255,255,255);padding: 2px; margin:2px">查</span><a
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=25&api=5855&data=87&vid=81"
         * target="_blank">资源池可用区查询</a>
         */
        @JsonProperty("azName")
        private String azName;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }
    }

    public static class AttachClusterNodesLabelsRequest {}

    public static class AttachClusterNodesAnnotationsRequest {}

    public static class AttachClusterNodesTaintsRequest {
        /** 键 */
        @JsonProperty("key")
        private String key;

        /** 值 */
        @JsonProperty("value")
        private String value;

        /** 策略 */
        @JsonProperty("effect")
        private String effect;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getEffect() {
            return this.effect;
        }

        public void setEffect(String effect) {
            this.effect = effect;
        }
    }

    public static class AttachClusterNodesKubeletArgsRequest {
        /** 请求至kube-apiserver的QPS配置 */
        @JsonProperty("kubeAPIQPS")
        private Integer kubeAPIQPS;

        /** 请求至kube-apiserver的Burst配置 */
        @JsonProperty("kubeAPIBurst")
        private Integer kubeAPIBurst;

        /** kubelet管理的pod上限 */
        @JsonProperty("maxPods")
        private Integer maxPods;

        /** 每秒钟可以执行的镜像仓库拉取操作限值 */
        @JsonProperty("registryPullQPS")
        private Integer registryPullQPS;

        /** 突发性镜像拉取的上限值 */
        @JsonProperty("registryBurst")
        private Integer registryBurst;

        /** 限制Pod中的进程数 */
        @JsonProperty("podPidsLimit")
        private Integer podPidsLimit;

        /** 事件创建QPS限制 */
        @JsonProperty("eventRecordQPS")
        private Integer eventRecordQPS;

        /** 事件创建的个数的突发峰值上限 */
        @JsonProperty("eventBurst")
        private Integer eventBurst;

        /** 拓扑管理策略的资源对齐粒度 */
        @JsonProperty("topologyManagerScope")
        private String topologyManagerScope;

        /** 是否为设置了CPU限制的容器实施CPU CFS配额约束,默认值为true */
        @JsonProperty("cpuCFSQuota")
        private Boolean cpuCFSQuota;

        public Integer getKubeAPIQPS() {
            return this.kubeAPIQPS;
        }

        public void setKubeAPIQPS(Integer kubeAPIQPS) {
            this.kubeAPIQPS = kubeAPIQPS;
        }

        public Integer getKubeAPIBurst() {
            return this.kubeAPIBurst;
        }

        public void setKubeAPIBurst(Integer kubeAPIBurst) {
            this.kubeAPIBurst = kubeAPIBurst;
        }

        public Integer getMaxPods() {
            return this.maxPods;
        }

        public void setMaxPods(Integer maxPods) {
            this.maxPods = maxPods;
        }

        public Integer getRegistryPullQPS() {
            return this.registryPullQPS;
        }

        public void setRegistryPullQPS(Integer registryPullQPS) {
            this.registryPullQPS = registryPullQPS;
        }

        public Integer getRegistryBurst() {
            return this.registryBurst;
        }

        public void setRegistryBurst(Integer registryBurst) {
            this.registryBurst = registryBurst;
        }

        public Integer getPodPidsLimit() {
            return this.podPidsLimit;
        }

        public void setPodPidsLimit(Integer podPidsLimit) {
            this.podPidsLimit = podPidsLimit;
        }

        public Integer getEventRecordQPS() {
            return this.eventRecordQPS;
        }

        public void setEventRecordQPS(Integer eventRecordQPS) {
            this.eventRecordQPS = eventRecordQPS;
        }

        public Integer getEventBurst() {
            return this.eventBurst;
        }

        public void setEventBurst(Integer eventBurst) {
            this.eventBurst = eventBurst;
        }

        public String getTopologyManagerScope() {
            return this.topologyManagerScope;
        }

        public void setTopologyManagerScope(String topologyManagerScope) {
            this.topologyManagerScope = topologyManagerScope;
        }

        public Boolean getCpuCFSQuota() {
            return this.cpuCFSQuota;
        }

        public void setCpuCFSQuota(Boolean cpuCFSQuota) {
            this.cpuCFSQuota = cpuCFSQuota;
        }
    }

    public static class AttachClusterNodesResourceLabelsRequest {}

    public static class AttachClusterNodesResponse {
        /** 响应状态码 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 请求ID */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应信息 */
        @JsonProperty("message")
        private String message;

        /** 响应对象 */
        @JsonProperty("returnObj")
        private Boolean returnObj;

        /** 错误码，参见错误码说明 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Boolean getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(Boolean returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
