/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.sdk;

import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.JacksonUtils;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.Response;

public class CtyunResponse {
    private final Request request;
    private final Response response;
    private final byte[] responseBody;

    protected CtyunResponse(Request request, Response response, byte[] responseBody) {
        this.request = request;
        this.response = response;
        this.responseBody = responseBody;
    }

    public <T> T parse(Class<T> cls) throws CtyunRequestException {
        if (this.responseBody == null || this.responseBody.length == 0) {
            return null;
        }
        try {
            return JacksonUtils.getObjectMapperInstance().readValue(this.responseBody, cls);
        }
        catch (IOException e) {
            throw new CtyunRequestException("error to parse response body: [ " + new String(this.responseBody) + " ] for class: [" + cls.toString() + "]", e);
        }
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }
}

