/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.sdk;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class CtyunRequestBuilder {
    private final String method;
    private String urlPath;
    private Credential credential;
    private String endpointName;

    public CtyunRequestBuilder(CtyunRequestTemplate template) {
        this.endpointName = template.endpointName;
        this.method = template.method;
        this.urlPath = template.urlPath;
    }

    public CtyunRequestBuilder replaceUrl(String src, Object target) {
        if (target == null) {
            return this;
        }
        String replace = null;
        try {
            replace = URLEncoder.encode(target.toString(), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        replace = replace.replaceAll("\\+", "%20");
        this.urlPath = this.urlPath.replace("{" + src + "}", replace);
        return this;
    }

    public CtyunRequestBuilder withCredential(Credential credential) {
        this.credential = credential;
        return this;
    }

    public CtyunRequestBuilder withEndpointName(String endpointName) {
        this.endpointName = endpointName;
        return this;
    }

    public CtyunRequest build() {
        return new CtyunRequest(this.method, this.urlPath, this.credential, this.endpointName);
    }
}

