/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.sdk;

import cn.ctyun.sdk.CtapiErrorResponse;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunResponse;
import cn.ctyun.sdk.Endpoint;
import cn.ctyun.sdk.EndpointRegistry;
import cn.ctyun.sdk.HttpHook;
import cn.ctyun.sdk.HttpHooks;
import cn.ctyun.sdk.JacksonUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class CtyunClient {
    private final CtyunClientConfig config;
    private final EndpointRegistry registry;

    public CtyunClient(CtyunClientConfig config) {
        this.config = config;
        this.registry = EndpointRegistry.defaultEndpointRegistry();
    }

    public static CtyunClientConfig clientConfigForProd() throws CtyunRequestException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectionPool(new ConnectionPool(5, 5L, TimeUnit.MINUTES)).connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS);
        return new CtyunClientConfig(builder.build());
    }

    public static CtyunClientConfig clientConfigForTest() throws CtyunRequestException {
        SSLContext sslContext;
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new CtyunRequestException("init SSLContext error", e);
        }
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        builder.sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]);
        builder.hostnameVerifier((hostname, session) -> true);
        builder.connectTimeout(0L, TimeUnit.MILLISECONDS);
        builder.readTimeout(0L, TimeUnit.MILLISECONDS);
        builder.writeTimeout(0L, TimeUnit.MILLISECONDS);
        return new CtyunClientConfig(builder.build()).addHook(new HttpHooks.PrintLogHttpHook());
    }

    public static CtyunClient clientForProd() throws CtyunRequestException {
        return new CtyunClient(CtyunClient.clientConfigForProd());
    }

    public static CtyunClient clientForTest() throws CtyunRequestException {
        return new CtyunClient(CtyunClient.clientConfigForTest());
    }

    public static CtyunClient defaultClient() throws CtyunRequestException {
        return new CtyunClient(CtyunClient.clientConfigForTest());
    }

    public void registerEndpoint(Endpoint endpoint) {
        this.registry.register(endpoint);
    }

    public CtyunResponse requestToEndpoint(CtyunRequest request) throws CtyunRequestException {
        String defaultUrl = this.registry.getEndpointUrl(request.getEndpointName());
        return this.send(request.buildRequest(defaultUrl));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CtyunResponse send(Request request) throws CtyunRequestException {
        for (HttpHook hook : this.config.hooks) {
            hook.beforeRequest(request);
        }
        try (Response response = this.config.client.newCall(request).execute();){
            for (HttpHook hook : this.config.hooks) {
                hook.afterResponse(response);
            }
            ResponseBody body = response.body();
            String bodyString = body.string();
            byte[] bytes = bodyString.getBytes(StandardCharsets.UTF_8);
            if (!response.isSuccessful()) {
                try {
                    CtapiErrorResponse ctapiErrorResponse = JacksonUtils.getObjectMapperInstance().readValue(bodyString, CtapiErrorResponse.class);
                    if (ctapiErrorResponse != null) {
                        bodyString = "{\"statusCode\":900,\"code\":" + ctapiErrorResponse.getCode() + ",\"error\":\"" + ctapiErrorResponse.getError() + "\",\"message\":\"" + ctapiErrorResponse.getMessage() + "\",\"msg\":\"" + ctapiErrorResponse.getMessage() + "\"}";
                        CtyunResponse ctyunResponse = new CtyunResponse(request, response, bodyString.getBytes(StandardCharsets.UTF_8));
                        return ctyunResponse;
                    }
                }
                catch (Exception ignore) {
                    System.out.println("Error to parse response body: " + bodyString);
                }
            }
            CtyunResponse ctyunResponse = new CtyunResponse(request, response, bytes);
            return ctyunResponse;
        }
        catch (IOException e) {
            throw new CtyunRequestException("request to url: [" + request.url() + "] error", e);
        }
    }

    public static class CtyunClientConfig {
        private final OkHttpClient client;
        private final List<HttpHook> hooks = new ArrayList<HttpHook>();

        public CtyunClientConfig(OkHttpClient client) {
            this.client = client;
        }

        public CtyunClientConfig addHook(HttpHook hook) {
            Objects.requireNonNull(hook);
            this.hooks.add(hook);
            return this;
        }
    }
}

