/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcShowBandwidthApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowBandwidthApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "GET", "/v4/bandwidth/describe", "application/json");
    }

    public ShowBandwidthResponse send(Credential credential, ShowBandwidthRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.bandwidthID != null) {
            ctReq.addParam("bandwidthID", request.bandwidthID);
            request.bandwidthID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowBandwidthResponse.class);
    }

    public static class ShowBandwidthReturnObjEipsResponse {
        @JsonProperty(value="ip")
        private String ip;
        @JsonProperty(value="eipID")
        private String eipID;

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getEipID() {
            return this.eipID;
        }

        public void setEipID(String eipID) {
            this.eipID = eipID;
        }
    }

    public static class ShowBandwidthReturnObjResponse {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="bandwidth")
        private Integer bandwidth;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="expireAt")
        private String expireAt;
        @JsonProperty(value="createdAt")
        private String createdAt;
        @JsonProperty(value="lineType")
        private String lineType;
        @JsonProperty(value="eips")
        private List<ShowBandwidthReturnObjEipsResponse> eips;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Integer getBandwidth() {
            return this.bandwidth;
        }

        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExpireAt() {
            return this.expireAt;
        }

        public void setExpireAt(String expireAt) {
            this.expireAt = expireAt;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getLineType() {
            return this.lineType;
        }

        public void setLineType(String lineType) {
            this.lineType = lineType;
        }

        public List<ShowBandwidthReturnObjEipsResponse> getEips() {
            return this.eips;
        }

        public void setEips(List<ShowBandwidthReturnObjEipsResponse> eips) {
            this.eips = eips;
        }
    }

    public static class ShowBandwidthResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ShowBandwidthReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowBandwidthReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowBandwidthReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowBandwidthRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="bandwidthID")
        private String bandwidthID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBandwidthID() {
            return this.bandwidthID;
        }

        public void setBandwidthID(String bandwidthID) {
            this.bandwidthID = bandwidthID;
        }
    }
}

