/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;

public class CtvpcModifyBandwidthSpecApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcModifyBandwidthSpecApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/bandwidth/modify-spec", "application/json");
    }

    public ModifyBandwidthSpecResponse send(Credential credential, ModifyBandwidthSpecRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyBandwidthSpecResponse.class);
    }

    public static class ModifyBandwidthSpecReturnObjResponse {
        @JsonProperty(value="masterOrderID")
        private String masterOrderID;
        @JsonProperty(value="masterOrderNO")
        private String masterOrderNO;
        @JsonProperty(value="masterResourceStatus")
        private String masterResourceStatus;
        @JsonProperty(value="masterResourceID")
        private String masterResourceID;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="bandwidthID")
        private String bandwidthID;

        public String getMasterOrderID() {
            return this.masterOrderID;
        }

        public void setMasterOrderID(String masterOrderID) {
            this.masterOrderID = masterOrderID;
        }

        public String getMasterOrderNO() {
            return this.masterOrderNO;
        }

        public void setMasterOrderNO(String masterOrderNO) {
            this.masterOrderNO = masterOrderNO;
        }

        public String getMasterResourceStatus() {
            return this.masterResourceStatus;
        }

        public void setMasterResourceStatus(String masterResourceStatus) {
            this.masterResourceStatus = masterResourceStatus;
        }

        public String getMasterResourceID() {
            return this.masterResourceID;
        }

        public void setMasterResourceID(String masterResourceID) {
            this.masterResourceID = masterResourceID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBandwidthID() {
            return this.bandwidthID;
        }

        public void setBandwidthID(String bandwidthID) {
            this.bandwidthID = bandwidthID;
        }
    }

    public static class ModifyBandwidthSpecResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private ModifyBandwidthSpecReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ModifyBandwidthSpecReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifyBandwidthSpecReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ModifyBandwidthSpecRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="bandwidthID")
        private String bandwidthID;
        @JsonProperty(value="bandwidth")
        private Integer bandwidth;
        @JsonProperty(value="payVoucherPrice")
        private String payVoucherPrice;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBandwidthID() {
            return this.bandwidthID;
        }

        public void setBandwidthID(String bandwidthID) {
            this.bandwidthID = bandwidthID;
        }

        public Integer getBandwidth() {
            return this.bandwidth;
        }

        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public String getPayVoucherPrice() {
            return this.payVoucherPrice;
        }

        public void setPayVoucherPrice(String payVoucherPrice) {
            this.payVoucherPrice = payVoucherPrice;
        }
    }
}

