/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcBandwidthQueryRenewPriceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcBandwidthQueryRenewPriceApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/bandwidth/query-renew-price", "application/json");
    }

    public BandwidthQueryRenewPriceResponse send(Credential credential, BandwidthQueryRenewPriceRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BandwidthQueryRenewPriceResponse.class);
    }

    public static class BandwidthQueryRenewPriceReturnObjSubOrderPricesOrderItemPricesResponse {
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="totalPrice")
        private Double totalPrice;
        @JsonProperty(value="finalPrice")
        private Double finalPrice;

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }
    }

    public static class BandwidthQueryRenewPriceReturnObjSubOrderPricesResponse {
        @JsonProperty(value="serviceTag")
        private String serviceTag;
        @JsonProperty(value="totalPrice")
        private Double totalPrice;
        @JsonProperty(value="finalPrice")
        private Double finalPrice;
        @JsonProperty(value="orderItemPrices")
        private List<BandwidthQueryRenewPriceReturnObjSubOrderPricesOrderItemPricesResponse> orderItemPrices;

        public String getServiceTag() {
            return this.serviceTag;
        }

        public void setServiceTag(String serviceTag) {
            this.serviceTag = serviceTag;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public List<BandwidthQueryRenewPriceReturnObjSubOrderPricesOrderItemPricesResponse> getOrderItemPrices() {
            return this.orderItemPrices;
        }

        public void setOrderItemPrices(List<BandwidthQueryRenewPriceReturnObjSubOrderPricesOrderItemPricesResponse> orderItemPrices) {
            this.orderItemPrices = orderItemPrices;
        }
    }

    public static class BandwidthQueryRenewPriceReturnObjResponse {
        @JsonProperty(value="totalPrice")
        private Double totalPrice;
        @JsonProperty(value="discountPrice")
        private Double discountPrice;
        @JsonProperty(value="finalPrice")
        private Double finalPrice;
        @JsonProperty(value="subOrderPrices")
        private List<BandwidthQueryRenewPriceReturnObjSubOrderPricesResponse> subOrderPrices;

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Double getDiscountPrice() {
            return this.discountPrice;
        }

        public void setDiscountPrice(Double discountPrice) {
            this.discountPrice = discountPrice;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public List<BandwidthQueryRenewPriceReturnObjSubOrderPricesResponse> getSubOrderPrices() {
            return this.subOrderPrices;
        }

        public void setSubOrderPrices(List<BandwidthQueryRenewPriceReturnObjSubOrderPricesResponse> subOrderPrices) {
            this.subOrderPrices = subOrderPrices;
        }
    }

    public static class BandwidthQueryRenewPriceResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private BandwidthQueryRenewPriceReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public BandwidthQueryRenewPriceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BandwidthQueryRenewPriceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class BandwidthQueryRenewPriceRequest {
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="bandwidthID")
        private String bandwidthID;
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="cycleType")
        private String cycleType;
        @JsonProperty(value="cycleCount")
        private Integer cycleCount;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBandwidthID() {
            return this.bandwidthID;
        }

        public void setBandwidthID(String bandwidthID) {
            this.bandwidthID = bandwidthID;
        }

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(String cycleType) {
            this.cycleType = cycleType;
        }

        public Integer getCycleCount() {
            return this.cycleCount;
        }

        public void setCycleCount(Integer cycleCount) {
            this.cycleCount = cycleCount;
        }
    }
}

