/*
 * Decompiled with CFR 0.152.
 */
package cn.ctyun.apis;

import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequest;
import cn.ctyun.sdk.CtyunRequestBuilder;
import cn.ctyun.sdk.CtyunRequestException;
import cn.ctyun.sdk.CtyunRequestTemplate;
import cn.ctyun.sdk.CtyunResponse;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class CtvpcBandwidthQueryCreatePriceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcBandwidthQueryCreatePriceApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate("ctvpc", "POST", "/v4/bandwidth/query-create-price", "application/json");
    }

    public BandwidthQueryCreatePriceResponse send(Credential credential, BandwidthQueryCreatePriceRequest request) throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(this.template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, this.template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BandwidthQueryCreatePriceResponse.class);
    }

    public static class BandwidthQueryCreatePriceReturnObjSubOrderPricesOrderItemPricesResponse {
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="totalPrice")
        private Double totalPrice;
        @JsonProperty(value="finalPrice")
        private Double finalPrice;

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }
    }

    public static class BandwidthQueryCreatePriceReturnObjSubOrderPricesResponse {
        @JsonProperty(value="serviceTag")
        private String serviceTag;
        @JsonProperty(value="totalPrice")
        private Double totalPrice;
        @JsonProperty(value="finalPrice")
        private Double finalPrice;
        @JsonProperty(value="orderItemPrices")
        private List<BandwidthQueryCreatePriceReturnObjSubOrderPricesOrderItemPricesResponse> orderItemPrices;

        public String getServiceTag() {
            return this.serviceTag;
        }

        public void setServiceTag(String serviceTag) {
            this.serviceTag = serviceTag;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public List<BandwidthQueryCreatePriceReturnObjSubOrderPricesOrderItemPricesResponse> getOrderItemPrices() {
            return this.orderItemPrices;
        }

        public void setOrderItemPrices(List<BandwidthQueryCreatePriceReturnObjSubOrderPricesOrderItemPricesResponse> orderItemPrices) {
            this.orderItemPrices = orderItemPrices;
        }
    }

    public static class BandwidthQueryCreatePriceReturnObjResponse {
        @JsonProperty(value="totalPrice")
        private Double totalPrice;
        @JsonProperty(value="discountPrice")
        private Double discountPrice;
        @JsonProperty(value="finalPrice")
        private Double finalPrice;
        @JsonProperty(value="subOrderPrices")
        private List<BandwidthQueryCreatePriceReturnObjSubOrderPricesResponse> subOrderPrices;

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Double getDiscountPrice() {
            return this.discountPrice;
        }

        public void setDiscountPrice(Double discountPrice) {
            this.discountPrice = discountPrice;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public List<BandwidthQueryCreatePriceReturnObjSubOrderPricesResponse> getSubOrderPrices() {
            return this.subOrderPrices;
        }

        public void setSubOrderPrices(List<BandwidthQueryCreatePriceReturnObjSubOrderPricesResponse> subOrderPrices) {
            this.subOrderPrices = subOrderPrices;
        }
    }

    public static class BandwidthQueryCreatePriceResponse {
        @JsonProperty(value="statusCode")
        private Integer statusCode;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="returnObj")
        private BandwidthQueryCreatePriceReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public BandwidthQueryCreatePriceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BandwidthQueryCreatePriceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class BandwidthQueryCreatePriceRequest {
        @JsonProperty(value="clientToken")
        private String clientToken;
        @JsonProperty(value="regionID")
        private String regionID;
        @JsonProperty(value="bandwidth")
        private Integer bandwidth;
        @JsonProperty(value="cycleType")
        private String cycleType;
        @JsonProperty(value="cycleCount")
        private Integer cycleCount;
        @JsonProperty(value="name")
        private String name;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getBandwidth() {
            return this.bandwidth;
        }

        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public String getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(String cycleType) {
            this.cycleType = cycleType;
        }

        public Integer getCycleCount() {
            return this.cycleCount;
        }

        public void setCycleCount(Integer cycleCount) {
            this.cycleCount = cycleCount;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

