package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询共享带宽实例详情。 */
public class CtvpcShowBandwidthApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcShowBandwidthApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/bandwidth/describe", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ShowBandwidthResponse send(Credential credential, ShowBandwidthRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.bandwidthID != null) {
            ctReq.addParam("bandwidthID", request.bandwidthID);
            request.bandwidthID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ShowBandwidthResponse.class);
    }

    public static class ShowBandwidthRequest {
        /** 共享带宽所在的区域id */
        @JsonProperty("regionID")
        private String regionID;

        /** 查询的共享带宽id。 */
        @JsonProperty("bandwidthID")
        private String bandwidthID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBandwidthID() {
            return this.bandwidthID;
        }

        public void setBandwidthID(String bandwidthID) {
            this.bandwidthID = bandwidthID;
        }
    }

    public static class ShowBandwidthResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回查询的共享带宽详细信息。 */
        @JsonProperty("returnObj")
        private ShowBandwidthReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public ShowBandwidthReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ShowBandwidthReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ShowBandwidthReturnObjResponse {
        /** 共享带宽id。 */
        @JsonProperty("id")
        private String id;

        /** ACTIVE */
        @JsonProperty("status")
        private String status;

        /** 共享带宽的带宽峰值， 单位：Mbps。 */
        @JsonProperty("bandwidth")
        private Integer bandwidth;

        /** 共享带宽名称。 */
        @JsonProperty("name")
        private String name;

        /** 过期时间 */
        @JsonProperty("expireAt")
        private String expireAt;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 线路类型 */
        @JsonProperty("lineType")
        private String lineType;

        /** 绑定的弹性 IP 列表，见下表 */
        @JsonProperty("eips")
        private List<ShowBandwidthReturnObjEipsResponse> eips;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Integer getBandwidth() {
            return this.bandwidth;
        }

        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExpireAt() {
            return this.expireAt;
        }

        public void setExpireAt(String expireAt) {
            this.expireAt = expireAt;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getLineType() {
            return this.lineType;
        }

        public void setLineType(String lineType) {
            this.lineType = lineType;
        }

        public List<ShowBandwidthReturnObjEipsResponse> getEips() {
            return this.eips;
        }

        public void setEips(List<ShowBandwidthReturnObjEipsResponse> eips) {
            this.eips = eips;
        }
    }

    public static class ShowBandwidthReturnObjEipsResponse {
        /** 弹性 IP 的 IP */
        @JsonProperty("ip")
        private String ip;

        /** 弹性 IP 的 ID */
        @JsonProperty("eipID")
        private String eipID;

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getEipID() {
            return this.eipID;
        }

        public void setEipID(String eipID) {
            this.eipID = eipID;
        }
    }
}
