package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询指定区域下共享带宽实例列表。 */
public class CtvpcListBandwidthApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcListBandwidthApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/bandwidth/list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListBandwidthResponse send(Credential credential, ListBandwidthRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.queryContent != null) {
            ctReq.addParam("queryContent", request.queryContent);
            request.queryContent = null;
        }
        if (request.projectID != null) {
            ctReq.addParam("projectID", request.projectID);
            request.projectID = null;
        }
        if (request.pageNumber != null) {
            ctReq.addParam("pageNumber", String.valueOf(request.pageNumber));
            request.pageNumber = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListBandwidthResponse.class);
    }

    public static class ListBandwidthRequest {
        /** 共享带宽所在的区域id。 */
        @JsonProperty("regionID")
        private String regionID;

        /** 【模糊查询】 共享带宽实例名称 / 带宽 ID */
        @JsonProperty("queryContent")
        private String queryContent;

        /** 企业项目 ID，默认为'0' */
        @JsonProperty("projectID")
        private String projectID;

        /** 列表的页码，默认值为 1。 */
        @JsonProperty("pageNumber")
        private Integer pageNumber;

        /** 列表的页码，默认值为 1, 推荐使用该字段, pageNumber 后续会废弃 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 分页查询时每页的行数，最大值为 50，默认值为 10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getQueryContent() {
            return this.queryContent;
        }

        public void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public Integer getPageNumber() {
            return this.pageNumber;
        }

        public void setPageNumber(Integer pageNumber) {
            this.pageNumber = pageNumber;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListBandwidthResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 列表条目数。 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 分页查询时每页的行数。 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 分页查询时总页数。 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 返回查询的共享带宽实例的详细信息。 */
        @JsonProperty("returnObj")
        private List<ListBandwidthReturnObjResponse> returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public List<ListBandwidthReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<ListBandwidthReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListBandwidthReturnObjResponse {
        /** 共享带宽id。 */
        @JsonProperty("id")
        private String id;

        /** 共享带宽状态: ACTIVE / EXPIRED / FREEZING */
        @JsonProperty("status")
        private String status;

        /** 共享带宽的带宽峰值， 单位：Mbps。 */
        @JsonProperty("bandwidth")
        private Integer bandwidth;

        /** 共享带宽名称。 */
        @JsonProperty("name")
        private String name;

        /** 过期时间 */
        @JsonProperty("expireAt")
        private String expireAt;

        /** 创建时间 */
        @JsonProperty("createdAt")
        private String createdAt;

        /** 线路类型 */
        @JsonProperty("lineType")
        private String lineType;

        /** 是否开启秒级监控 */
        @JsonProperty("enableSecondLevelMonitor")
        private Boolean enableSecondLevelMonitor;

        /** 绑定的弹性 IP 列表 */
        @JsonProperty("eips")
        private List<ListBandwidthReturnObjEipsResponse> eips;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Integer getBandwidth() {
            return this.bandwidth;
        }

        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getExpireAt() {
            return this.expireAt;
        }

        public void setExpireAt(String expireAt) {
            this.expireAt = expireAt;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getLineType() {
            return this.lineType;
        }

        public void setLineType(String lineType) {
            this.lineType = lineType;
        }

        public Boolean getEnableSecondLevelMonitor() {
            return this.enableSecondLevelMonitor;
        }

        public void setEnableSecondLevelMonitor(Boolean enableSecondLevelMonitor) {
            this.enableSecondLevelMonitor = enableSecondLevelMonitor;
        }

        public List<ListBandwidthReturnObjEipsResponse> getEips() {
            return this.eips;
        }

        public void setEips(List<ListBandwidthReturnObjEipsResponse> eips) {
            this.eips = eips;
        }
    }

    public static class ListBandwidthReturnObjEipsResponse {
        /** 弹性 IP 的 IP */
        @JsonProperty("ip")
        private String ip;

        /** 弹性 IP 的 ID */
        @JsonProperty("eipID")
        private String eipID;

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getEipID() {
            return this.eipID;
        }

        public void setEipID(String eipID) {
            this.eipID = eipID;
        }
    }
}
