package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用此接口可创建共享带宽。 */
public class CtvpcCreateBandwidthApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcCreateBandwidthApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/bandwidth/create", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateBandwidthResponse send(Credential credential, CreateBandwidthRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateBandwidthResponse.class);
    }

    public static class CreateBandwidthRequest {
        /** 客户端存根，用于保证订单幂等性, 长度 1 - 64 */
        @JsonProperty("clientToken")
        private String clientToken;

        /** 创建共享带宽的区域id。 */
        @JsonProperty("regionID")
        private String regionID;

        /** 共享带宽的带宽峰值，必须大于等于 5。5-1000 */
        @JsonProperty("bandwidth")
        private Integer bandwidth;

        /** 企业项目 ID，默认为'0' */
        @JsonProperty("projectID")
        private String projectID;

        /**
         * 订购类型：包年/包月订购，或按需订购。<br>
         * month / year / on_demand
         */
        @JsonProperty("cycleType")
        private String cycleType;

        /**
         * 订购时长, cycleType 是 on_demand 为可选，当 cycleType = month, 支持续订 1 - 11 个月; 当 cycleType = year,
         * 支持续订 1 - 3 年
         */
        @JsonProperty("cycleCount")
        private Integer cycleCount;

        /** 支持拉丁字母、中文、数字，下划线，连字符，中文 / 英文字母开头，不能以 http: / https: 开头，长度 2 - 32 */
        @JsonProperty("name")
        private String name;

        /** 代金券金额，支持到小数点后两位 */
        @JsonProperty("payVoucherPrice")
        private String payVoucherPrice;

        public String getClientToken() {
            return this.clientToken;
        }

        public void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getBandwidth() {
            return this.bandwidth;
        }

        public void setBandwidth(Integer bandwidth) {
            this.bandwidth = bandwidth;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public String getCycleType() {
            return this.cycleType;
        }

        public void setCycleType(String cycleType) {
            this.cycleType = cycleType;
        }

        public Integer getCycleCount() {
            return this.cycleCount;
        }

        public void setCycleCount(Integer cycleCount) {
            this.cycleCount = cycleCount;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPayVoucherPrice() {
            return this.payVoucherPrice;
        }

        public void setPayVoucherPrice(String payVoucherPrice) {
            this.payVoucherPrice = payVoucherPrice;
        }
    }

    public static class CreateBandwidthResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 业务数据 */
        @JsonProperty("returnObj")
        private CreateBandwidthReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public CreateBandwidthReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateBandwidthReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateBandwidthReturnObjResponse {
        /** 订单id。 */
        @JsonProperty("masterOrderID")
        private String masterOrderID;

        /** 订单编号, 可以为 null。 */
        @JsonProperty("masterOrderNO")
        private String masterOrderNO;

        /**
         * 资源状态: started（启用） / renewed（续订） / refunded（退订） / destroyed（销毁） / failed（失败） /
         * starting（正在启用） / changed（变配）/ expired（过期）/ unknown（未知）
         */
        @JsonProperty("masterResourceStatus")
        private String masterResourceStatus;

        /** 可以为 null。 */
        @JsonProperty("masterResourceID")
        private String masterResourceID;

        /** 可用区id。 */
        @JsonProperty("regionID")
        private String regionID;

        /** 带宽 ID，当 masterResourceStatus 不为 started, 该值可为 null */
        @JsonProperty("bandwidthID")
        private String bandwidthID;

        public String getMasterOrderID() {
            return this.masterOrderID;
        }

        public void setMasterOrderID(String masterOrderID) {
            this.masterOrderID = masterOrderID;
        }

        public String getMasterOrderNO() {
            return this.masterOrderNO;
        }

        public void setMasterOrderNO(String masterOrderNO) {
            this.masterOrderNO = masterOrderNO;
        }

        public String getMasterResourceStatus() {
            return this.masterResourceStatus;
        }

        public void setMasterResourceStatus(String masterResourceStatus) {
            this.masterResourceStatus = masterResourceStatus;
        }

        public String getMasterResourceID() {
            return this.masterResourceID;
        }

        public void setMasterResourceID(String masterResourceID) {
            this.masterResourceID = masterResourceID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBandwidthID() {
            return this.bandwidthID;
        }

        public void setBandwidthID(String bandwidthID) {
            this.bandwidthID = bandwidthID;
        }
    }
}
