package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 入方向带宽利用率。 */
public class CtvpcBandwidthIngerssBandwidthUtilizationApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public CtvpcBandwidthIngerssBandwidthUtilizationApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/bandwidth/ingress-bandwidth-utilization",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BandwidthIngerssBandwidthUtilizationResponse send(
            Credential credential, BandwidthIngerssBandwidthUtilizationRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.bandwidthID != null) {
            ctReq.addParam("bandwidthID", request.bandwidthID);
            request.bandwidthID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BandwidthIngerssBandwidthUtilizationResponse.class);
    }

    public static class BandwidthIngerssBandwidthUtilizationRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 带宽 ID */
        @JsonProperty("bandwidthID")
        private String bandwidthID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBandwidthID() {
            return this.bandwidthID;
        }

        public void setBandwidthID(String bandwidthID) {
            this.bandwidthID = bandwidthID;
        }
    }

    public static class BandwidthIngerssBandwidthUtilizationResponse {
        /** 返回状态码（800为成功，900为失败） */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** statusCode为900时的错误信息; statusCode为800时为success, 英文 */
        @JsonProperty("message")
        private String message;

        /** statusCode为900时的错误信息; statusCode为800时为成功, 中文 */
        @JsonProperty("description")
        private String description;

        /** statusCode为900时为业务细分错误码，三段式：product.module.code; statusCode为800时为SUCCESS */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 返回结果 */
        @JsonProperty("returnObj")
        private BandwidthIngerssBandwidthUtilizationReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public BandwidthIngerssBandwidthUtilizationReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BandwidthIngerssBandwidthUtilizationReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class BandwidthIngerssBandwidthUtilizationReturnObjResponse {
        /** 入方向带宽利用率 */
        @JsonProperty("ingressBandwidthUtilization")
        private String ingressBandwidthUtilization;

        public String getIngressBandwidthUtilization() {
            return this.ingressBandwidthUtilization;
        }

        public void setIngressBandwidthUtilization(String ingressBandwidthUtilization) {
            this.ingressBandwidthUtilization = ingressBandwidthUtilization;
        }
    }
}
