/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.zipkin.config;

import cn.crushes.cloud.core.zipkin.props.ZipkinProperties;
import cn.crushes.cloud.core.zipkin.sender.RSocketSender;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.transport.ClientTransport;
import io.rsocket.transport.netty.client.TcpClientTransport;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import zipkin2.reporter.Sender;

@Configuration
@ComponentScan(value={"cn.crushes.cloud.core.zipkin.config"})
@EnableConfigurationProperties(value={ZipkinProperties.class})
@ConditionalOnProperty(value={"crush.cloud.zipkin.enable"}, havingValue="true", matchIfMissing=true)
public class ZipkinConfiguration {
    @Resource
    private ZipkinProperties zipkinProperties;

    @Bean
    public RSocket rsocket() {
        return (RSocket)RSocketConnector.create().dataMimeType("application/vnd.google.protobuf").connect((ClientTransport)TcpClientTransport.create((String)this.zipkinProperties.getAddress(), (int)this.zipkinProperties.getPort())).block();
    }

    @Bean(value={"zipkinSender"})
    public Sender zipkinRSocketSender(RSocket rocket) {
        return new RSocketSender(rocket);
    }
}

