package cn.crushes.cloud.core.zipkin.config;

import cn.crushes.cloud.core.zipkin.props.ZipkinProperties;
import cn.crushes.cloud.core.zipkin.sender.RSocketSender;
import io.rsocket.RSocket;
import io.rsocket.core.RSocketConnector;
import io.rsocket.transport.netty.client.TcpClientTransport;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import zipkin2.reporter.Sender;

import javax.annotation.Resource;

/**
 * @author youta
 */
@Configuration
@ComponentScan(value = "cn.crushes.cloud.core.zipkin.config")
@EnableConfigurationProperties(ZipkinProperties.class)
@ConditionalOnProperty(value = ZipkinProperties.PREFIX + ".enable", havingValue = "true", matchIfMissing = true)
public class ZipkinConfiguration {

    @Resource
    private ZipkinProperties zipkinProperties;

    @Bean
    public RSocket rsocket() {
        return RSocketConnector
                .create()
                .dataMimeType("application/vnd.google.protobuf")
                .connect(TcpClientTransport.create(zipkinProperties.getAddress(),zipkinProperties.getPort()))
                .block();
    }


    @Bean(ZipkinAutoConfiguration.SENDER_BEAN_NAME)
    public Sender zipkinRSocketSender(RSocket rocket) {
        return new RSocketSender(rocket);
    }
    
}