/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.webflux.handler;

import cn.crushes.cloud.core.common.enums.CodeEnum;
import cn.crushes.cloud.core.common.exception.BusinessException;
import cn.crushes.cloud.core.common.exception.PayException;
import cn.crushes.cloud.core.common.exception.RocketMqException;
import cn.crushes.cloud.core.common.exception.TokenException;
import cn.crushes.cloud.core.common.model.Result;
import cn.hutool.core.util.StrUtil;
import io.netty.channel.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ResponseStatusException;

@RestControllerAdvice
public class ExceptionHandlerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    @ExceptionHandler(value={ResponseStatusException.class})
    public Result handle(ResponseStatusException ex) {
        log.error("response status exception", (Throwable)ex);
        if (StrUtil.contains((CharSequence)ex.getMessage(), (CharSequence)HttpStatus.NOT_FOUND.toString())) {
            return Result.error((Integer)CodeEnum.NOT_FOUND.getCode(), (String)ex.getMessage());
        }
        return Result.error();
    }

    @ExceptionHandler(value={ConnectTimeoutException.class})
    public Result handle(ConnectTimeoutException ex) {
        log.error("connect timeout exception", (Throwable)ex);
        return Result.error();
    }

    @ExceptionHandler(value={BusinessException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result handle(BusinessException ex) {
        log.error("business exception", (Throwable)ex);
        return Result.error((Integer)ex.getCode(), (String)ex.getMsg());
    }

    @ExceptionHandler(value={PayException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result handle(PayException ex) {
        log.error("pay exception", (Throwable)ex);
        return Result.error((Integer)ex.getCode(), (String)ex.getMsg());
    }

    @ExceptionHandler(value={RocketMqException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result handle(RocketMqException ex) {
        log.error("rocket exception", (Throwable)ex);
        return Result.error((Integer)ex.getCode(), (String)ex.getMsg());
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result handle(RuntimeException ex) {
        log.error("runtime exception", (Throwable)ex);
        return Result.error();
    }

    @ExceptionHandler(value={TokenException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public Result handle(TokenException ex) {
        log.error("token exception");
        return Result.error((Integer)HttpStatus.UNAUTHORIZED.value(), (String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Result handle(Exception ex) {
        log.error("exception", (Throwable)ex);
        return Result.error();
    }

    @ExceptionHandler(value={Throwable.class})
    public Result handle(Throwable throwable) {
        Result result = Result.error();
        if (throwable instanceof ResponseStatusException) {
            result = this.handle((ResponseStatusException)throwable);
        } else if (throwable instanceof ConnectTimeoutException) {
            result = this.handle((ConnectTimeoutException)throwable);
        } else if (throwable instanceof TokenException) {
            result = this.handle((TokenException)throwable);
        } else if (throwable instanceof RuntimeException) {
            result = this.handle((RuntimeException)throwable);
        } else if (throwable instanceof Exception) {
            result = this.handle((Exception)throwable);
        }
        return result;
    }
}

