/*
 * Decompiled with CFR 0.152.
 */
package cn.crushes.cloud.core.webflux.id;

import cn.crushes.cloud.core.webflux.id.IdHelper;
import cn.crushes.cloud.core.webflux.id.contract.IdGeneratorException;
import cn.crushes.cloud.core.webflux.id.contract.IdGeneratorOptions;
import cn.crushes.cloud.core.webflux.id.props.IdGenProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={IdGenProperties.class})
public class IdConfig
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(IdConfig.class);
    private final IdGenProperties idGenProperties;

    public IdConfig(IdGenProperties idGenProperties) {
        this.idGenProperties = idGenProperties;
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.idGenProperties.getWorkerId() == null) {
            throw new IdGeneratorException("IdHelper options error.");
        }
        IdGeneratorOptions options = new IdGeneratorOptions(this.idGenProperties.getWorkerId().shortValue());
        IdHelper.setIdGenerator(options);
    }
}

