package cn.crushes.cloud.core.webflux.id;

import cn.crushes.cloud.core.webflux.id.contract.IdGeneratorException;
import cn.crushes.cloud.core.webflux.id.contract.IdGeneratorOptions;
import cn.crushes.cloud.core.webflux.id.props.IdGenProperties;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author youta
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(value = {IdGenProperties.class})
public class IdConfig implements ApplicationRunner {

    private final IdGenProperties idGenProperties;

    public IdConfig(IdGenProperties idGenProperties) {
        this.idGenProperties = idGenProperties;
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        if (idGenProperties.getWorkerId() ==null){
            throw new IdGeneratorException("IdHelper options error.");
        }
        IdGeneratorOptions options = new IdGeneratorOptions(idGenProperties.getWorkerId().shortValue());
        IdHelper.setIdGenerator(options);
    }
}
