package cn.crushes.cloud.core.pay.wechat.v3.model.discountcard;

import cn.crushes.cloud.core.pay.wechat.enumeration.ContractStatus;
import cn.crushes.cloud.core.pay.wechat.enumeration.CountType;
import lombok.Data;

import java.util.List;

/**
 * 用户领取微信先享卡通知解密
 *
 * @author youta
 */
@Data
public class DiscountCardAcceptedConsumeData {

    /**
     * 应用appid需要绑定微信商户平台
     */
    private String appid;
    /**
     * 先享卡ID，唯一标识一个先享卡
     */
    private String cardId;
    /**
     * 先享卡模板ID，唯一定义此资源的标识。创建模板后可获得
     */
    private String cardTemplateId;
    /**
     * 创建先享卡的时间
     */
    private String createTime;
    /**
     * 商户号
     */
    private String mchid;
    /**
     * 用户先享卡目标列表
     */
    private List<Objective> objectives;
    /**
     * 用户标识，用户在{@code appid}下的唯一标识
     */
    private String openid;
    /**
     * 商户领卡号，商户在请求领卡预受理接口时传入的领卡请求号，同一个商户号下必须唯一，要求32个字符内，只能是数字、大小写字母_-|*
     */
    private String outCardCode;
    /**
     * 用户先享卡优惠列表
     */
    private List<Reward> rewards;
    /**
     * 邀请者用户标识
     * <p>
     * 微信用户在商户对应appid下的唯一标识。
     * 仅当此卡是通过“邀请有礼”渠道领卡时，会返回此字段；指此先享卡是通过此[邀请者]邀请领卡成功的。当此先享卡完成约定时，商户可给此[邀请者]下发应邀请有礼的奖励
     */
    private String sharerOpenid;
    /**
     * 先享卡的守约状态
     */
    private ContractStatus state;
    /**
     * 约定时间期限
     */
    private TimeRange timeRange;

    /**
     * 用户先享卡目标列表
     *
     * @author youta
     */
    @Data
    public static class Objective {

        /**
         * 目标数量
         * <p>
         * 履约目标需要完成的数量，必须大于0。
         */
        private Long count;
        /**
         * 目标描述
         */
        private String description;
        /**
         * 目标名称
         */
        private String name;
        /**
         * 目标id
         */
        private String objectiveId;
        /**
         * 目标单位
         * <p>
         * 示例值：次
         */
        private String unit;

    }

    /**
     * 用户先享卡优惠列表
     *
     * @author youta
     */
    @Data
    public static class Reward {

        /**
         * 优惠金额
         * <p>
         * 1、优惠金额，此项优惠对应的优惠总金额，单位：分，必须大于0。
         * 2、此项优惠已享累计金额≤创建模板时配置的此项奖励的奖励金额，
         * 例如：优惠为【满10元减3元优惠券4张】时，用户一次消费使用了2张优惠券，优惠金额为本次优惠总金额6元，优惠数量为本次使用优惠的优惠券数量2张
         */
        private Long amount;
        /**
         * 优惠数量
         */
        private Long count;
        /**
         * 优惠数量类型
         */
        private CountType countType;
        /**
         * 优惠描述
         */
        private String description;
        /**
         * 优惠名称
         */
        private String name;
        /**
         * 优惠ID
         */
        private String rewardId;
        /**
         * 优惠单位，例如 “个”
         */
        private String unit;

    }

    /**
     * 先享卡约定时间期限
     *
     * @author youta
     */
    @Data
    public static class TimeRange {
        /**
         * 开始时间
         */
        private String betinTime;
        /**
         * 结束时间
         */
        private String endTime;
    }

}
