package cn.crushes.cloud.core.pay.wechat.v3.model.busifavor;

import cn.crushes.cloud.core.pay.wechat.enumeration.FavorUseMethod;
import cn.crushes.cloud.core.pay.wechat.enumeration.StockType;
import lombok.Data;

/**
 * 商家券核销规则
 *
 * @author youta
 */
@Data
public class CouponUseRule {

    /**
     * 核销方式
     */
    private FavorUseMethod useMethod;
    /**
     * 换购券使用规则
     *
     * @see StockType#EXCHANGE
     */
    private ExchangeCoupon exchangeCoupon;
    /**
     * 券可核销时间
     */
    private CouponAvailableTime couponAvailableTime;
    /**
     * 核销小程序appid
     *
     * @see FavorUseMethod#MINI_PROGRAMS
     */
    private String miniProgramsAppid;
    /**
     * 核销小程序path
     *
     * @see #miniProgramsAppid
     */
    private String miniProgramsPath;
    /**
     * 固定面额满减券使用规则
     *
     * @see StockType#NORMAL
     */
    private FixedNormalCoupon fixedNormalCoupon;
    /**
     * 折扣券使用规则
     *
     * @see StockType#DISCOUNT
     */
    private DiscountCoupon discountCoupon;

}