package cn.crushes.cloud.core.pay.wechat.v3.model.busifavor;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.time.OffsetDateTime;

/**
 * 核销用户券请求参数
 *
 * @author youta
 */
@Data
public class BusiFavorUseParams {
    /**
     * 券code
     */
    private String couponCode;
    /**
     * 批次号
     */
    private String stockId;
    /**
     * 公众账号ID
     */
    private String appid;
    /**
     * 请求核销时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd'T'HH:mm:ssXXX", timezone = "GMT+8")
    private OffsetDateTime useTime;
    /**
     * 核销请求单据号,商户侧保证唯一
     */
    private String useRequestNo;
    /**
     * 用户标识，用户的唯一标识，做安全校验使用
     */
    private String openid;

}
